/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.AnyFinder;

public class OracleAnyFinder
extends AnyFinder {
    public OracleAnyFinder(PlainSchemaDAO plainSchemaDAO, EntityManager entityManager) {
        super(plainSchemaDAO, entityManager);
    }

    @Override
    protected String queryBegin(String table) {
        return "SELECT DISTINCT id FROM " + this.view(table) + " ";
    }

    @Override
    protected Object getAttrValue(PlainSchema schema, PlainAttrValue attrValue, boolean ignoreCaseMatch) {
        return schema.getType() == AttrSchemaType.Boolean ? BooleanUtils.toStringTrueFalse((Boolean)attrValue.getBooleanValue()) : (schema.getType() == AttrSchemaType.String && ignoreCaseMatch ? StringUtils.lowerCase((String)attrValue.getStringValue()) : attrValue.getValue());
    }

    @Override
    protected String attrValueMatch(AnyUtils anyUtils, PlainSchema schema, PlainAttrValue attrValue, boolean ignoreCaseMatch) {
        StringBuilder query = new StringBuilder("plainSchema = ? AND ");
        Pair<String, Boolean> schemaInfo = this.schemaInfo(schema.getType(), ignoreCaseMatch);
        query.append((Boolean)schemaInfo.getRight() != false ? "LOWER(" : "");
        if (schema.isUniqueConstraint()) {
            query.append("u").append((String)schemaInfo.getLeft());
        } else {
            query.append("JSON_VALUE(").append((String)schemaInfo.getLeft()).append(", '$[*]')");
        }
        query.append((Boolean)schemaInfo.getRight() != false ? ")" : "").append(" = ").append((Boolean)schemaInfo.getRight() != false ? "LOWER(" : "").append('?').append((Boolean)schemaInfo.getRight() != false ? ")" : "");
        return query.toString();
    }
}

