/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.AbstractJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

public class MariaDBJPAAnySearchDAO
extends AbstractJPAAnySearchDAO {
    public MariaDBJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @Override
    protected String getQuery(AttrCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Pair checked = this.check(cond, svs.anyTypeKind);
        if (not) {
            if (cond.getType() == AttrCond.Type.ISNULL) {
                cond.setType(AttrCond.Type.ISNOTNULL);
            } else if (cond.getType() == AttrCond.Type.ISNOTNULL) {
                cond.setType(AttrCond.Type.ISNULL);
            }
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ");
        switch (cond.getType()) {
            case ISNOTNULL: {
                query.append("JSON_SEARCH(plainAttrs, 'one', '").append(((PlainSchema)checked.getLeft()).getKey()).append("', NULL, '$[*].schema') IS NOT NULL");
                break;
            }
            case ISNULL: {
                query.append("JSON_SEARCH(plainAttrs, 'one', '").append(((PlainSchema)checked.getLeft()).getKey()).append("', NULL, '$[*].schema') IS NULL");
                break;
            }
            default: {
                if (!not && cond.getType() == AttrCond.Type.EQ) {
                    PlainAttr container = this.anyUtilsFactory.getInstance(svs.anyTypeKind).newPlainAttr();
                    container.setSchema((PlainSchema)checked.getLeft());
                    Object object = checked.getRight();
                    if (object instanceof PlainAttrUniqueValue) {
                        PlainAttrUniqueValue plainAttrUniqueValue = (PlainAttrUniqueValue)object;
                        container.setUniqueValue(plainAttrUniqueValue);
                    } else {
                        container.add((PlainAttrValue)checked.getRight());
                    }
                    query.append("JSON_CONTAINS(plainAttrs, '").append(POJOHelper.serialize(List.of(container)).replace("'", "''")).append("')");
                    break;
                }
                query = new StringBuilder("SELECT DISTINCT any_id FROM ");
                if (not && !(cond instanceof AnyCond) && ((PlainSchema)checked.getLeft()).isMultivalue()) {
                    query.append(svs.field().name()).append(" WHERE ");
                } else {
                    query.append(((PlainSchema)checked.getLeft()).isUniqueConstraint() ? svs.asSearchViewSupport().uniqueAttr().name() : svs.asSearchViewSupport().attr().name()).append(" WHERE schema_id='").append(((PlainSchema)checked.getLeft()).getKey());
                }
                Optional.ofNullable(((PlainAttrValue)checked.getRight()).getDateValue()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).ifPresent(formatted -> {
                    ((PlainAttrValue)checked.getRight()).setDateValue(null);
                    ((PlainAttrValue)checked.getRight()).setStringValue(formatted);
                });
                this.fillAttrQuery(query, (PlainAttrValue)checked.getRight(), (PlainSchema)checked.getLeft(), cond, not, parameters, svs);
            }
        }
        return query.toString();
    }
}

