/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NoResultException;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTaskCommand;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class JPATaskDAO
implements TaskDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(TaskDAO.class);
    protected final RealmSearchDAO realmSearchDAO;
    protected final RemediationDAO remediationDAO;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final SecurityProperties securityProperties;
    protected final EntityManager entityManager;

    public JPATaskDAO(RealmSearchDAO realmSearchDAO, RemediationDAO remediationDAO, TaskUtilsFactory taskUtilsFactory, SecurityProperties securityProperties, EntityManager entityManager) {
        this.realmSearchDAO = realmSearchDAO;
        this.remediationDAO = remediationDAO;
        this.taskUtilsFactory = taskUtilsFactory;
        this.securityProperties = securityProperties;
        this.entityManager = entityManager;
    }

    public boolean existsById(String key) {
        return this.findById(key).isPresent();
    }

    @Transactional(readOnly=true)
    public <T extends Task<T>> Optional<T> findById(TaskType type, String key) {
        return Optional.ofNullable((Task)this.entityManager.find(this.taskUtilsFactory.getInstance(type).getTaskEntity(), (Object)key));
    }

    @Transactional(readOnly=true)
    public <T extends SchedTask> Optional<T> findByName(TaskType type, String name) {
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(type);
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + taskUtils.getTaskEntity().getSimpleName() + " e WHERE e.name = :name", taskUtils.getTaskEntity());
        query.setParameter("name", (Object)name);
        try {
            return Optional.of((SchedTask)query.getSingleResult());
        }
        catch (NoResultException e) {
            LOG.debug("No task found with name {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<? extends Task<?>> findById(String key) {
        Optional task = this.findById(TaskType.SCHEDULED, key);
        if (task.isEmpty()) {
            task = this.findById(TaskType.PULL, key);
        }
        if (task.isEmpty()) {
            task = this.findById(TaskType.PUSH, key);
        }
        if (task.isEmpty()) {
            task = this.findById(TaskType.MACRO, key);
        }
        if (task.isEmpty()) {
            task = this.findById(TaskType.PROPAGATION, key);
        }
        if (task.isEmpty()) {
            task = this.findById(TaskType.NOTIFICATION, key);
        }
        return task;
    }

    public List<SchedTask> findByDelegate(Implementation delegate) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPASchedTask.class.getSimpleName() + " e WHERE e.jobDelegate=:delegate", SchedTask.class);
        query.setParameter("delegate", (Object)delegate);
        return query.getResultList();
    }

    public List<PullTask> findByReconFilterBuilder(Implementation reconFilterBuilder) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAPullTask.class.getSimpleName() + " e WHERE e.reconFilterBuilder=:reconFilterBuilder", PullTask.class);
        query.setParameter("reconFilterBuilder", (Object)reconFilterBuilder);
        return query.getResultList();
    }

    public List<PullTask> findByInboundActions(Implementation inboundActions) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAPullTask.class.getSimpleName() + " e WHERE :inboundActions MEMBER OF e.actions", PullTask.class);
        query.setParameter("inboundActions", (Object)inboundActions);
        return query.getResultList();
    }

    public List<PushTask> findByPushActions(Implementation pushActions) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAPushTask.class.getSimpleName() + " e WHERE :pushActions MEMBER OF e.actions", PushTask.class);
        query.setParameter("pushActions", (Object)pushActions);
        return query.getResultList();
    }

    public List<MacroTask> findByRealm(Realm realm) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAMacroTask.class.getSimpleName() + " e WHERE e.realm=:realm", MacroTask.class);
        query.setParameter("realm", (Object)realm);
        return query.getResultList();
    }

    public List<MacroTask> findByCommand(Implementation command) {
        TypedQuery query = this.entityManager.createQuery("SELECT e.macroTask FROM " + JPAMacroTaskCommand.class.getSimpleName() + " e WHERE e.command=:command", MacroTask.class);
        query.setParameter("command", (Object)command);
        return query.getResultList();
    }

    protected final <T extends Task<T>> StringBuilder buildFindAllQuery(TaskType type) {
        StringBuilder builder = new StringBuilder("SELECT t FROM ").append(this.taskUtilsFactory.getInstance(type).getTaskEntity().getSimpleName()).append(" t WHERE ");
        if (type == TaskType.SCHEDULED) {
            builder.append("t.id NOT IN (SELECT t.id FROM ").append(JPAPushTask.class.getSimpleName()).append(" t) ").append("AND ").append("t.id NOT IN (SELECT t.id FROM ").append(JPAPullTask.class.getSimpleName()).append(" t)");
        } else {
            builder.append("1=1");
        }
        return builder.append(' ');
    }

    public <T extends Task<T>> List<T> findToExec(TaskType type) {
        StringBuilder queryString = this.buildFindAllQuery(type).append("AND ");
        if (type == TaskType.NOTIFICATION) {
            queryString.append("t.executed = false ");
        } else {
            queryString.append("t.executions IS EMPTY ");
        }
        queryString.append("ORDER BY t.id DESC");
        Query query = this.entityManager.createQuery(queryString.toString());
        return query.getResultList();
    }

    public List<? extends Task<?>> findAll() {
        throw new UnsupportedOperationException();
    }

    @Transactional(readOnly=true)
    public <T extends Task<T>> List<T> findAll(TaskType type) {
        return this.findAll(type, null, null, null, null, Pageable.unpaged());
    }

    protected int setParameter(List<Object> parameters, Object parameter) {
        parameters.add(parameter);
        return parameters.size();
    }

    protected StringBuilder buildFindAllQuery(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, boolean orderByTaskExecInfo, List<Object> parameters) {
        if (resource != null && type != TaskType.PROPAGATION && type != TaskType.LIVE_SYNC && type != TaskType.PUSH && type != TaskType.PULL) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not related to " + ExternalResource.class.getSimpleName());
        }
        if ((anyTypeKind != null || entityKey != null) && type != TaskType.PROPAGATION && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not related to users, groups or any objects");
        }
        if (notification != null && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not related to notifications");
        }
        String taskTable = this.taskUtilsFactory.getInstance(type).getTaskStorage();
        StringBuilder queryString = new StringBuilder("SELECT ").append(taskTable).append(".*");
        if (orderByTaskExecInfo) {
            String taskExecTable = this.taskUtilsFactory.getInstance(type).getTaskExecStorage();
            queryString.append(',').append(taskExecTable).append(".startDate AS startDate").append(',').append(taskExecTable).append(".endDate AS endDate").append(',').append(taskExecTable).append(".status AS status").append(" FROM ").append(taskTable).append(',').append(taskExecTable).append(',').append("(SELECT ").append(taskExecTable).append(".task_id, ").append("MAX(").append(taskExecTable).append(".startDate) AS startDate").append(" FROM ").append(taskExecTable).append(" GROUP BY ").append(taskExecTable).append(".task_id) GRP").append(" WHERE ").append(taskTable).append(".id=").append(taskExecTable).append(".task_id").append(" AND ").append(taskTable).append(".id=").append("GRP.task_id").append(" AND ").append(taskExecTable).append(".startDate=").append("GRP.startDate");
        } else {
            queryString.append(", null AS startDate, null AS endDate, null AS status FROM ").append(taskTable).append(" WHERE 1=1");
        }
        queryString.append(' ');
        if (resource != null) {
            queryString.append(" AND ").append(taskTable).append(".resource_id=?").append(this.setParameter(parameters, resource.getKey()));
        }
        if (notification != null) {
            queryString.append(" AND ").append(taskTable).append(".notification_id=?").append(this.setParameter(parameters, notification.getKey()));
        }
        if (anyTypeKind != null) {
            queryString.append(" AND ").append(taskTable).append(".anyTypeKind=?").append(this.setParameter(parameters, anyTypeKind.name()));
        }
        if (entityKey != null) {
            queryString.append(" AND ").append(taskTable).append(".entityKey=?").append(this.setParameter(parameters, entityKey));
        }
        if (type == TaskType.MACRO && !AuthContextUtils.getUsername().equals(this.securityProperties.getAdminUser())) {
            String realmKeysArg = ((Set)AuthContextUtils.getAuthorizations().get("TASK_LIST")).stream().map(arg_0 -> ((RealmSearchDAO)this.realmSearchDAO).findByFullPath(arg_0)).filter(Optional::isPresent).flatMap(r -> this.realmSearchDAO.findDescendants(((Realm)r.get()).getFullPath(), null, Pageable.unpaged()).stream()).map(Entity::getKey).distinct().map(realmKey -> "?" + this.setParameter(parameters, realmKey)).collect(Collectors.joining(","));
            queryString.append(" AND ").append(taskTable).append(".realm_id IN (").append(realmKeysArg).append(")");
        }
        return queryString;
    }

    protected String toOrderByStatement(Class<? extends Task<?>> beanClass, Stream<Sort.Order> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        statement.append(" ORDER BY ");
        StringBuilder subStatement = new StringBuilder();
        orderByClauses.forEach(clause -> {
            Object field = clause.getProperty().trim();
            switch (field) {
                case "latestExecStatus": {
                    field = "status";
                    break;
                }
                case "start": {
                    field = "startDate";
                    break;
                }
                case "end": {
                    field = "endDate";
                    break;
                }
                default: {
                    Field beanField = ReflectionUtils.findField((Class)beanClass, (String)field);
                    if (beanField == null || beanField.getAnnotation(ManyToOne.class) == null && beanField.getAnnotation(OneToMany.class) == null && beanField.getAnnotation(OneToOne.class) == null) break;
                    field = (String)field + "_id";
                }
            }
            subStatement.append((String)field).append(' ').append(clause.getDirection().name()).append(',');
        });
        if (subStatement.length() == 0) {
            statement.append("id DESC");
        } else {
            subStatement.deleteCharAt(subStatement.length() - 1);
            statement.append((CharSequence)subStatement);
        }
        return statement.toString();
    }

    public <T extends Task<T>> List<T> findAll(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, Pageable pageable) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        boolean orderByTaskExecInfo = pageable.getSort().stream().anyMatch(clause -> clause.getProperty().equals("start") || clause.getProperty().equals("end") || clause.getProperty().equals("latestExecStatus") || clause.getProperty().equals("status"));
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, orderByTaskExecInfo, parameters);
        if (orderByTaskExecInfo) {
            queryString.insert(0, "SELECT T.id FROM ((").append(") UNION ALL (").append((CharSequence)this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, false, parameters)).append(" AND id NOT IN ").append("(SELECT task_id AS id FROM ").append(this.taskUtilsFactory.getInstance(type).getTaskExecStorage()).append(')').append(")) T");
        } else {
            queryString.insert(0, "SELECT T.id FROM (").append(") T");
        }
        queryString.append(this.toOrderByStatement(this.taskUtilsFactory.getInstance(type).getTaskEntity(), pageable.getSort().stream()));
        Query query = this.entityManager.createNativeQuery(queryString.toString());
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        ArrayList result = new ArrayList();
        List raw = query.getResultList();
        raw.forEach(key -> this.findById(type, key.toString()).ifPresentOrElse(task -> result.add(task), () -> LOG.error("Could not find task with key {}, even if returned by native query", key)));
        return result;
    }

    public long count() {
        throw new UnsupportedOperationException();
    }

    public long count(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, false, parameters);
        String table = this.taskUtilsFactory.getInstance(type).getTaskStorage();
        Query query = this.entityManager.createNativeQuery(StringUtils.replaceOnce((String)queryString.toString(), (String)("SELECT " + table + ".*, null AS startDate, null AS endDate, null AS status"), (String)("SELECT COUNT(" + table + ".id)")));
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        return ((Number)query.getSingleResult()).longValue();
    }

    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task<?>> T save(T task) {
        T t = task;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JPANotificationTask.class, JPAPushTask.class}, t2, n)) {
            case 0: {
                JPANotificationTask jpaNotificationTask = (JPANotificationTask)t2;
                jpaNotificationTask.list2json();
                break;
            }
            case 1: {
                JPAPushTask jpaPushTask = (JPAPushTask)t2;
                jpaPushTask.map2json();
                break;
            }
        }
        return (T)((Task)this.entityManager.merge(task));
    }

    public void delete(TaskType type, String key) {
        this.findById(type, key).ifPresent(this::delete);
    }

    public void deleteById(String key) {
        this.findById(key).ifPresent(this::delete);
    }

    public void delete(Task<?> task) {
        if (task instanceof PullTask) {
            PullTask pullTask = (PullTask)task;
            this.remediationDAO.findByPullTask(pullTask).forEach(remediation -> remediation.setPullTask(null));
        }
        this.entityManager.remove(task);
    }

    public void deleteAll(ExternalResource resource, TaskType type) {
        this.findAll(type, resource, null, null, null, Pageable.unpaged()).stream().map(Entity::getKey).forEach(key -> this.delete(type, (String)key));
    }

    public List<PropagationTaskTO> purgePropagations(OffsetDateTime since, List<ExecStatus> statuses, List<String> resources) {
        StringBuilder queryString = new StringBuilder("SELECT t.task_id FROM PropagationTaskExec t INNER JOIN PropagationTask z ON t.task_id=z.id WHERE t.enddate=(SELECT MAX(e.enddate) FROM PropagationTaskExec e WHERE e.task_id=t.task_id) ");
        ArrayList<OffsetDateTime> queryParameters = new ArrayList<OffsetDateTime>();
        if (since != null) {
            queryParameters.add(since);
            queryString.append("AND t.enddate <= ?").append(queryParameters.size()).append(' ');
        }
        if (!CollectionUtils.isEmpty(statuses)) {
            queryString.append("AND (").append(statuses.stream().map(status -> {
                queryParameters.add((OffsetDateTime)((Object)status.name()));
                return "t.status = ?" + queryParameters.size();
            }).collect(Collectors.joining(" OR "))).append(")");
        }
        if (!CollectionUtils.isEmpty(resources)) {
            queryString.append("AND (").append(resources.stream().map(r -> {
                queryParameters.add((OffsetDateTime)r);
                return "z.resource_id = ?" + queryParameters.size();
            }).collect(Collectors.joining(" OR "))).append(")");
        }
        Query query = this.entityManager.createNativeQuery(queryString.toString());
        for (int i = 1; i <= queryParameters.size(); ++i) {
            query.setParameter(i, queryParameters.get(i - 1));
        }
        List raw = query.getResultList();
        ArrayList<PropagationTaskTO> purged = new ArrayList<PropagationTaskTO>();
        raw.stream().map(Object::toString).distinct().forEach(key -> this.findById(TaskType.PROPAGATION, (String)key).map(PropagationTask.class::cast).ifPresent(task -> {
            PropagationTaskTO taskTO = new PropagationTaskTO();
            taskTO.setOperation(task.getOperation());
            taskTO.setConnObjectKey(task.getConnObjectKey());
            taskTO.setOldConnObjectKey(task.getOldConnObjectKey());
            taskTO.setPropagationData(task.getSerializedPropagationData());
            taskTO.setResource(task.getResource().getKey());
            taskTO.setObjectClassName(task.getObjectClassName());
            taskTO.setAnyTypeKind(task.getAnyTypeKind());
            taskTO.setAnyType(task.getAnyType());
            taskTO.setEntityKey(task.getEntityKey());
            purged.add(taskTO);
            this.delete((Task<?>)task);
        }));
        return purged;
    }
}

