/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AnyFinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AnyFinder.class);
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final EntityManager entityManager;

    protected static List<String> split(String attrValue, List<String> literals) {
        ArrayList<String> attrValues = new ArrayList<String>();
        if (literals.isEmpty()) {
            attrValues.add(attrValue);
        } else {
            for (String token : attrValue.split(Pattern.quote(literals.get(0)))) {
                if (token.isEmpty()) continue;
                attrValues.addAll(AnyFinder.split(token, literals.subList(1, literals.size())));
            }
        }
        return attrValues;
    }

    protected AnyFinder(PlainSchemaDAO plainSchemaDAO, EntityManager entityManager) {
        this.plainSchemaDAO = plainSchemaDAO;
        this.entityManager = entityManager;
    }

    protected String view(String table) {
        return StringUtils.containsIgnoreCase((CharSequence)table, (CharSequence)AnyTypeKind.USER.name()) ? "user_search" : (StringUtils.containsIgnoreCase((CharSequence)table, (CharSequence)AnyTypeKind.GROUP.name()) ? "group_search" : "anyObject_search");
    }

    protected abstract String queryBegin(String var1);

    protected Pair<String, Boolean> schemaInfo(AttrSchemaType schemaType, boolean ignoreCaseMatch) {
        boolean lower = false;
        return Pair.of((Object)(switch (schemaType) {
            case AttrSchemaType.Boolean -> "booleanValue";
            case AttrSchemaType.Date -> "dateValue";
            case AttrSchemaType.Double -> "doubleValue";
            case AttrSchemaType.Long -> "longValue";
            case AttrSchemaType.Binary -> "binaryValue";
            default -> {
                lower = ignoreCaseMatch;
                yield "stringValue";
            }
        }), (Object)lower);
    }

    protected abstract String attrValueMatch(AnyUtils var1, PlainSchema var2, PlainAttrValue var3, boolean var4);

    protected Object getAttrValue(PlainSchema schema, PlainAttrValue attrValue, boolean ignoreCaseMatch) {
        return attrValue.getValue();
    }

    protected <A extends Any<?>> List<A> buildResult(AnyUtils anyUtils, List<Object> queryResult) {
        ArrayList result = new ArrayList();
        queryResult.forEach(anyKey -> anyUtils.dao().findById(anyKey.toString()).ifPresentOrElse(result::add, () -> LOG.error("Could not find any for key {}", anyKey)));
        return result;
    }

    protected String plainAttrQuery(String table, AnyUtils anyUtils, PlainSchema schema, PlainAttrValue attrValue, boolean ignoreCaseMatch, List<Object> queryParams) {
        queryParams.add(schema.getKey());
        queryParams.add(this.getAttrValue(schema, attrValue, ignoreCaseMatch));
        return this.queryBegin(table) + "WHERE " + this.attrValueMatch(anyUtils, schema, attrValue, ignoreCaseMatch);
    }

    @Transactional(readOnly=true)
    public <A extends Any<?>> List<A> findByPlainAttrValue(String table, AnyUtils anyUtils, PlainSchema schema, PlainAttrValue attrValue, boolean ignoreCaseMatch) {
        if (schema == null) {
            LOG.error("No PlainSchema");
            return List.of();
        }
        ArrayList<Object> queryParams = new ArrayList<Object>();
        Query query = this.entityManager.createNativeQuery(this.plainAttrQuery(table, anyUtils, schema, attrValue, ignoreCaseMatch, queryParams));
        for (int i = 0; i < queryParams.size(); ++i) {
            query.setParameter(i + 1, queryParams.get(i));
        }
        return this.buildResult(anyUtils, query.getResultList());
    }

    @Transactional(readOnly=true)
    public <A extends Any<?>> Optional<A> findByPlainAttrUniqueValue(String table, AnyUtils anyUtils, PlainSchema schema, PlainAttrUniqueValue attrUniqueValue, boolean ignoreCaseMatch) {
        if (schema == null) {
            LOG.error("No PlainSchema");
            return Optional.empty();
        }
        if (!schema.isUniqueConstraint()) {
            LOG.error("This schema has not unique constraint: '{}'", (Object)schema.getKey());
            return Optional.empty();
        }
        List<A> result = this.findByPlainAttrValue(table, anyUtils, schema, (PlainAttrValue)attrUniqueValue, ignoreCaseMatch);
        return result.isEmpty() ? Optional.empty() : Optional.of((Any)result.get(0));
    }

    private List<Object> findByDerAttrValue(String table, Map<String, List<Object>> clauses) {
        StringJoiner actualClauses = new StringJoiner(" AND id IN ");
        ArrayList queryParams = new ArrayList();
        clauses.forEach((clause, parameters) -> {
            actualClauses.add((CharSequence)clause);
            queryParams.addAll(parameters);
        });
        Query query = this.entityManager.createNativeQuery("SELECT DISTINCT id FROM " + table + " u WHERE id IN " + actualClauses.toString());
        for (int i = 0; i < queryParams.size(); ++i) {
            query.setParameter(i + 1, queryParams.get(i));
        }
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public <A extends Any<?>> List<A> findByDerAttrValue(String table, AnyUtils anyUtils, DerSchema derSchema, String value, boolean ignoreCaseMatch) {
        if (derSchema == null) {
            LOG.error("No DerSchema");
            return List.of();
        }
        Parser parser = new Parser(derSchema.getExpression());
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList<String> literals = new ArrayList<String>();
        Token token = parser.getNextToken();
        while (token != null && StringUtils.isNotBlank((CharSequence)token.toString())) {
            if (token.kind == 124) {
                literals.add(token.toString().substring(1, token.toString().length() - 1));
            }
            if (token.kind == 110) {
                identifiers.add(token.toString());
            }
            token = parser.getNextToken();
        }
        literals.sort((l1, l2) -> {
            if (l1 == null && l2 == null) {
                return 0;
            }
            if (l1 != null && l2 == null) {
                return -1;
            }
            if (l1 == null) {
                return 1;
            }
            if (l1.length() == l2.length()) {
                return 0;
            }
            if (l1.length() > l2.length()) {
                return -1;
            }
            return 1;
        });
        List<String> attrValues = AnyFinder.split(value, literals);
        if (attrValues.size() != identifiers.size()) {
            LOG.error("Ambiguous JEXL expression resolution: literals and values have different size");
            return List.of();
        }
        LinkedHashMap<String, List<Object>> clauses = new LinkedHashMap<String, List<Object>>();
        StringBuilder bld = new StringBuilder();
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < identifiers.size(); ++i) {
            if (used.contains(identifiers.get(i))) continue;
            PlainSchema schema = this.plainSchemaDAO.findById((String)identifiers.get(i)).orElse(null);
            if (schema == null) {
                LOG.error("Invalid schema '{}', ignoring", identifiers.get(i));
                continue;
            }
            bld.delete(0, bld.length());
            PlainAttrUniqueValue attrValue = schema.isUniqueConstraint() ? anyUtils.newPlainAttrUniqueValue() : anyUtils.newPlainAttrValue();
            attrValue.setStringValue(attrValues.get(i));
            ArrayList<Object> queryParams = new ArrayList<Object>();
            bld.append('(').append(this.plainAttrQuery(table, anyUtils, schema, (PlainAttrValue)attrValue, ignoreCaseMatch, queryParams)).append(')');
            used.add((String)identifiers.get(i));
            clauses.put(bld.toString(), queryParams);
        }
        LOG.debug("Generated where clauses {}", clauses);
        return this.buildResult(anyUtils, this.findByDerAttrValue(table, clauses));
    }
}

