/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.PrivilegeCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.common.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchViewSupport;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

abstract class AbstractJPAAnySearchDAO
extends AbstractAnySearchDAO {
    protected static final String SELECT_COLS_FROM_VIEW = "any_id,creationContext,creationDate,creator,lastChangeContext,lastChangeDate,lastModifier,status,changePwdDate,cipherAlgorithm,failedLogins,lastLoginDate,mustChangePassword,suspended,username";
    private static final Map<String, Boolean> IS_ORACLE = new ConcurrentHashMap<String, Boolean>();
    protected final EntityManagerFactory entityManagerFactory;
    protected final EntityManager entityManager;

    protected static int setParameter(List<Object> parameters, Object parameter) {
        parameters.add(parameter);
        return parameters.size();
    }

    protected static void fillWithParameters(Query query, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object object = parameters.get(i);
            if (object instanceof Boolean) {
                Boolean aBoolean = (Boolean)object;
                query.setParameter(i + 1, (Object)(aBoolean != false ? 1 : 0));
                continue;
            }
            query.setParameter(i + 1, parameters.get(i));
        }
    }

    protected AbstractJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, plainSchemaDAO, entityFactory, anyUtilsFactory, validator);
        this.entityManagerFactory = entityManagerFactory;
        this.entityManager = entityManager;
    }

    protected boolean isOracle() {
        return IS_ORACLE.computeIfAbsent(AuthContextUtils.getDomain(), k -> {
            OpenJPAEntityManagerFactorySPI emfspi = (OpenJPAEntityManagerFactorySPI)this.entityManagerFactory.unwrap(OpenJPAEntityManagerFactorySPI.class);
            return ((MappingRepository)emfspi.getConfiguration().getMetaDataRepositoryInstance()).getDBDictionary() instanceof OracleDictionary;
        });
    }

    protected String buildAdminRealmsFilter(Set<String> realmKeys, SearchSupport svs, List<Object> parameters) {
        if (realmKeys.isEmpty()) {
            return "u.any_id IS NOT NULL";
        }
        String realmKeysArg = realmKeys.stream().map(realmKey -> "?" + AbstractJPAAnySearchDAO.setParameter(parameters, realmKey)).collect(Collectors.joining(","));
        return "u.any_id IN (SELECT any_id FROM " + svs.field().name() + " WHERE realm_id IN (" + realmKeysArg + "))";
    }

    protected Triple<String, Set<String>, Set<String>> getAdminRealmsFilter(Realm base, boolean recursive, Set<String> adminRealms, SearchSupport svs, List<Object> parameters) {
        HashSet<String> realmKeys = new HashSet<String>();
        HashSet dynRealmKeys = new HashSet();
        HashSet groupOwners = new HashSet();
        if (recursive) {
            adminRealms.forEach(realmPath -> RealmUtils.parseGroupOwnerRealm((String)realmPath).ifPresentOrElse(goRealm -> groupOwners.add((String)goRealm.getRight()), () -> {
                if (realmPath.startsWith("/")) {
                    Realm realm = (Realm)this.realmSearchDAO.findByFullPath(realmPath).orElseThrow(() -> {
                        SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                        noRealm.getElements().add("Invalid realm specified: " + realmPath);
                        return noRealm;
                    });
                    realmKeys.addAll(this.realmSearchDAO.findDescendants(realm.getFullPath(), base.getFullPath()));
                } else {
                    this.dynRealmDAO.findById(realmPath).ifPresentOrElse(dynRealm -> dynRealmKeys.add(dynRealm.getKey()), () -> LOG.warn("Ignoring invalid dynamic realm {}", realmPath));
                }
            }));
            if (!dynRealmKeys.isEmpty()) {
                realmKeys.clear();
            }
        } else if (adminRealms.stream().anyMatch(r -> r.startsWith(base.getFullPath()))) {
            realmKeys.add(base.getKey());
        }
        return Triple.of((Object)this.buildAdminRealmsFilter(realmKeys, svs, parameters), dynRealmKeys, groupOwners);
    }

    SearchSupport buildSearchSupport(AnyTypeKind kind) {
        return new SearchViewSupport(kind);
    }

    protected long doCount(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        SearchSupport svs = this.buildSearchSupport(kind);
        Triple<String, Set<String>, Set<String>> filter = this.getAdminRealmsFilter(base, recursive, adminRealms, svs, parameters);
        Pair<StringBuilder, Set<String>> queryInfo = this.getQuery(AbstractJPAAnySearchDAO.buildEffectiveCond((SearchCond)cond, (Set)((Set)filter.getMiddle()), (Set)((Set)filter.getRight()), (AnyTypeKind)kind), parameters, svs);
        StringBuilder queryString = (StringBuilder)queryInfo.getLeft();
        queryString.insert(0, "SELECT u.any_id FROM (");
        queryString.append(") u WHERE ").append((String)filter.getLeft());
        queryString.insert(0, "SELECT COUNT(any_id) FROM (");
        queryString.append(") count_any_id");
        Query countQuery = this.entityManager.createNativeQuery(queryString.toString());
        AbstractJPAAnySearchDAO.fillWithParameters(countQuery, parameters);
        return ((Number)countQuery.getSingleResult()).longValue();
    }

    protected <T extends Any<?>> List<T> doSearch(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, Pageable pageable, AnyTypeKind kind) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        SearchSupport svs = this.buildSearchSupport(kind);
        try {
            Triple<String, Set<String>, Set<String>> filter = this.getAdminRealmsFilter(base, recursive, adminRealms, svs, parameters);
            Pair<StringBuilder, Set<String>> queryInfo = this.getQuery(AbstractJPAAnySearchDAO.buildEffectiveCond((SearchCond)cond, (Set)((Set)filter.getMiddle()), (Set)((Set)filter.getRight()), (AnyTypeKind)kind), parameters, svs);
            StringBuilder queryString = (StringBuilder)queryInfo.getLeft();
            LOG.debug("Query: {}, parameters: {}", (Object)queryString, parameters);
            OrderBySupport obs = this.parseOrderBy(svs, pageable.getSort().get());
            if (queryString.charAt(0) == '(') {
                queryString.insert(0, this.buildSelect(obs));
            } else {
                queryString.insert(0, this.buildSelect(obs).append('('));
                queryString.append(')');
            }
            queryString.append((CharSequence)this.buildWhere(svs, obs)).append((String)filter.getLeft()).append((CharSequence)this.buildOrderBy(obs));
            LOG.debug("Query with auth and order by statements: {}, parameters: {}", (Object)queryString, parameters);
            Query query = this.entityManager.createNativeQuery(queryString.toString());
            if (pageable.isPaged()) {
                query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
                query.setMaxResults(pageable.getPageSize());
            }
            AbstractJPAAnySearchDAO.fillWithParameters(query, parameters);
            return this.buildResult(query.getResultList(), kind);
        }
        catch (SyncopeClientException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("While searching for {}", (Object)kind, (Object)e);
            return List.of();
        }
    }

    protected StringBuilder buildSelect(OrderBySupport obs) {
        StringBuilder select = new StringBuilder("SELECT DISTINCT u.any_id");
        obs.items.forEach(item -> select.append(',').append(item.select));
        select.append(" FROM ");
        return select;
    }

    protected void processOBS(SearchSupport svs, OrderBySupport obs, StringBuilder where) {
        Set attrs = obs.items.stream().map(item -> item.orderBy.substring(0, item.orderBy.indexOf(32))).collect(Collectors.toSet());
        obs.views.forEach(searchView -> {
            where.append(',');
            boolean searchViewAddedToWhere = false;
            if (searchView.name().equals(svs.asSearchViewSupport().attr().name())) {
                StringBuilder attrWhere = new StringBuilder();
                StringBuilder nullAttrWhere = new StringBuilder();
                if (svs.nonMandatorySchemas || obs.nonMandatorySchemas) {
                    where.append(" (SELECT * FROM ").append(searchView.name());
                    searchViewAddedToWhere = true;
                    attrs.forEach(field -> {
                        if (attrWhere.length() == 0) {
                            attrWhere.append(" WHERE ");
                        } else {
                            attrWhere.append(" OR ");
                        }
                        attrWhere.append("schema_id='").append((String)field).append("'");
                        nullAttrWhere.append(" UNION SELECT any_id, ").append("'").append((String)field).append("' AS schema_id, ").append("null AS booleanvalue, ").append("null AS datevalue, ").append("null AS doublevalue, ").append("null AS longvalue, ").append("null AS stringvalue FROM ").append(svs.field().name()).append(" WHERE ").append("any_id NOT IN (").append("SELECT any_id FROM ").append(svs.asSearchViewSupport().attr().name()).append(' ').append(searchView.alias()).append(" WHERE ").append("schema_id='").append((String)field).append("')");
                    });
                    where.append((CharSequence)attrWhere).append((CharSequence)nullAttrWhere).append(')');
                }
            }
            if (!searchViewAddedToWhere) {
                where.append(searchView.name());
            }
            where.append(' ').append(searchView.alias());
        });
    }

    protected StringBuilder buildWhere(SearchSupport svs, OrderBySupport obs) {
        StringBuilder where = new StringBuilder(" u");
        this.processOBS(svs, obs, where);
        where.append(" WHERE ");
        obs.views.forEach(searchView -> where.append("u.any_id=").append(searchView.alias()).append(".any_id AND "));
        obs.items.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.where)).forEach(item -> where.append(item.where).append(" AND "));
        return where;
    }

    protected StringBuilder buildOrderBy(OrderBySupport obs) {
        StringBuilder orderBy = new StringBuilder();
        if (!obs.items.isEmpty()) {
            obs.items.forEach(item -> orderBy.append(item.orderBy).append(','));
            orderBy.insert(0, " ORDER BY ");
            orderBy.deleteCharAt(orderBy.length() - 1);
        }
        return orderBy;
    }

    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, Sort.Order clause, PlainSchema schema, String fieldName) {
        boolean bl = obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        if (schema.isUniqueConstraint()) {
            obs.views.add(svs.asSearchViewSupport().uniqueAttr());
            item.select = svs.asSearchViewSupport().uniqueAttr().alias() + '.' + AbstractJPAAnySearchDAO.key((AttrSchemaType)schema.getType()) + " AS " + fieldName;
            item.where = svs.asSearchViewSupport().uniqueAttr().alias() + ".schema_id='" + fieldName + "'";
            item.orderBy = fieldName + " " + clause.getDirection().name();
        } else {
            obs.views.add(svs.asSearchViewSupport().attr());
            item.select = svs.asSearchViewSupport().attr().alias() + '.' + AbstractJPAAnySearchDAO.key((AttrSchemaType)schema.getType()) + " AS " + fieldName;
            item.where = svs.asSearchViewSupport().attr().alias() + ".schema_id='" + fieldName + "'";
            item.orderBy = fieldName + " " + clause.getDirection().name();
        }
    }

    protected void parseOrderByForField(SearchSupport svs, OrderBySupport.Item item, String fieldName, Sort.Order clause) {
        item.select = svs.field().alias() + "." + fieldName;
        item.where = "";
        item.orderBy = svs.field().alias() + "." + fieldName + " " + clause.getDirection().name();
    }

    protected void parseOrderByForCustom(SearchSupport svs, Sort.Order clause, OrderBySupport.Item item, OrderBySupport obs) {
    }

    protected OrderBySupport parseOrderBy(SearchSupport svs, Stream<Sort.Order> orderBy) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(svs.anyTypeKind);
        OrderBySupport obs = new OrderBySupport();
        HashSet orderByUniquePlainSchemas = new HashSet();
        HashSet orderByNonUniquePlainSchemas = new HashSet();
        orderBy.forEach(clause -> {
            OrderBySupport.Item item = new OrderBySupport.Item();
            this.parseOrderByForCustom(svs, (Sort.Order)clause, item, obs);
            if (item.isEmpty()) {
                if (anyUtils.getField(clause.getProperty()).isPresent()) {
                    Object fieldName = clause.getProperty();
                    if (ArrayUtils.contains((Object[])RELATIONSHIP_FIELDS, (Object)fieldName)) {
                        fieldName = (String)fieldName + "_id";
                    }
                    obs.views.add(svs.field());
                    this.parseOrderByForField(svs, item, (String)fieldName, (Sort.Order)clause);
                } else {
                    this.plainSchemaDAO.findById(clause.getProperty()).ifPresent(schema -> {
                        if (schema.isUniqueConstraint()) {
                            orderByUniquePlainSchemas.add(schema.getKey());
                        } else {
                            orderByNonUniquePlainSchemas.add(schema.getKey());
                        }
                        if (orderByUniquePlainSchemas.size() > 1 || orderByNonUniquePlainSchemas.size() > 1) {
                            SyncopeClientException invalidSearch = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
                            invalidSearch.getElements().add("Order by more than one attribute is not allowed; remove one from " + String.valueOf(orderByUniquePlainSchemas.size() > 1 ? orderByUniquePlainSchemas : orderByNonUniquePlainSchemas));
                            throw invalidSearch;
                        }
                        this.parseOrderByForPlainSchema(svs, obs, item, (Sort.Order)clause, (PlainSchema)schema, clause.getProperty());
                    });
                }
            }
            if (item.isEmpty()) {
                LOG.warn("Cannot build any valid clause from {}", clause);
            } else {
                obs.items.add(item);
            }
        });
        return obs;
    }

    protected void getQueryForCustomConds(SearchCond cond, List<Object> parameters, SearchSupport svs, boolean not, StringBuilder query) {
    }

    protected void queryOp(StringBuilder query, String op, Pair<StringBuilder, Set<String>> leftInfo, Pair<StringBuilder, Set<String>> rightInfo) {
        String subQuery = ((StringBuilder)leftInfo.getLeft()).toString();
        subQuery = subQuery.replaceFirst("WHERE ", "WHERE (");
        query.append(subQuery).append(' ').append(op).append(" any_id IN ( ").append((CharSequence)rightInfo.getLeft()).append("))");
    }

    protected Pair<StringBuilder, Set<String>> getQuery(SearchCond cond, List<Object> parameters, SearchSupport svs) {
        boolean not = cond.getType() == SearchCond.Type.NOT_LEAF;
        StringBuilder query = new StringBuilder();
        HashSet involvedPlainAttrs = new HashSet();
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                cond.getLeaf(AnyTypeCond.class).filter(leaf -> AnyTypeKind.ANY_OBJECT == svs.anyTypeKind).ifPresent(leaf -> query.append(this.getQuery((AnyTypeCond)leaf, not, parameters, svs)));
                cond.getLeaf(AuxClassCond.class).ifPresent(leaf -> query.append(this.getQuery((AuxClassCond)leaf, not, parameters, svs)));
                cond.getLeaf(RelationshipTypeCond.class).filter(leaf -> AnyTypeKind.GROUP != svs.anyTypeKind).ifPresent(leaf -> query.append(this.getQuery((RelationshipTypeCond)leaf, not, parameters, svs)));
                cond.getLeaf(RelationshipCond.class).filter(leaf -> AnyTypeKind.GROUP != svs.anyTypeKind).ifPresent(leaf -> query.append(this.getQuery((RelationshipCond)leaf, not, parameters, svs)));
                cond.getLeaf(MembershipCond.class).filter(leaf -> AnyTypeKind.GROUP != svs.anyTypeKind).ifPresent(leaf -> query.append(this.getQuery((MembershipCond)leaf, not, parameters, svs)));
                cond.getLeaf(MemberCond.class).filter(leaf -> AnyTypeKind.GROUP == svs.anyTypeKind).ifPresent(leaf -> query.append(this.getQuery((MemberCond)leaf, not, parameters, svs)));
                cond.getLeaf(RoleCond.class).filter(leaf -> AnyTypeKind.USER == svs.anyTypeKind).ifPresent(leaf -> query.append(this.getQuery((RoleCond)leaf, not, parameters, svs)));
                cond.getLeaf(PrivilegeCond.class).filter(leaf -> AnyTypeKind.USER == svs.anyTypeKind).ifPresent(leaf -> query.append(this.getQuery((PrivilegeCond)leaf, not, parameters, svs)));
                cond.getLeaf(DynRealmCond.class).ifPresent(leaf -> query.append(this.getQuery((DynRealmCond)leaf, not, parameters, svs)));
                cond.getLeaf(ResourceCond.class).ifPresent(leaf -> query.append(this.getQuery((ResourceCond)leaf, not, parameters, svs)));
                cond.getLeaf(AnyCond.class).ifPresentOrElse(anyCond -> query.append(this.getQuery((AnyCond)anyCond, not, parameters, svs)), () -> cond.getLeaf(AttrCond.class).ifPresent(leaf -> {
                    query.append(this.getQuery((AttrCond)leaf, not, parameters, svs));
                    try {
                        involvedPlainAttrs.add(((PlainSchema)this.check((AttrCond)leaf, svs.anyTypeKind).getLeft()).getKey());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }));
                this.getQueryForCustomConds(cond, parameters, svs, not, query);
                break;
            }
            case AND: {
                Pair<StringBuilder, Set<String>> leftAndInfo = this.getQuery(cond.getLeft(), parameters, svs);
                involvedPlainAttrs.addAll((Collection)leftAndInfo.getRight());
                Pair<StringBuilder, Set<String>> rigthAndInfo = this.getQuery(cond.getRight(), parameters, svs);
                involvedPlainAttrs.addAll((Collection)rigthAndInfo.getRight());
                this.queryOp(query, "AND", leftAndInfo, rigthAndInfo);
                break;
            }
            case OR: {
                Pair<StringBuilder, Set<String>> leftOrInfo = this.getQuery(cond.getLeft(), parameters, svs);
                involvedPlainAttrs.addAll((Collection)leftOrInfo.getRight());
                Pair<StringBuilder, Set<String>> rigthOrInfo = this.getQuery(cond.getRight(), parameters, svs);
                involvedPlainAttrs.addAll((Collection)rigthOrInfo.getRight());
                this.queryOp(query, "OR", leftOrInfo, rigthOrInfo);
                break;
            }
        }
        return Pair.of((Object)query, involvedPlainAttrs);
    }

    protected String getQuery(AnyTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE type_id");
        if (not) {
            query.append("<>");
        } else {
            query.append('=');
        }
        query.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getAnyTypeKey()));
        return query.toString();
    }

    protected String getQuery(AuxClassCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.auxClass().name()).append(" WHERE anyTypeClass_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getAuxClass())).append(')');
        return query.toString();
    }

    protected String getQuery(RelationshipTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT any_id ").append("FROM ").append(svs.relationship().name()).append(" WHERE type=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getRelationshipTypeKey())).append(" UNION SELECT right_any_id AS any_id FROM ").append(svs.relationship().name()).append(" WHERE type=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getRelationshipTypeKey())).append(')');
        return query.toString();
    }

    protected String getQuery(RelationshipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Set rightAnyObjects = this.check(cond);
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.relationship().name()).append(" WHERE ").append(rightAnyObjects.stream().map(key -> "right_any_id=?" + AbstractJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(')');
        return query.toString();
    }

    protected String getQuery(MembershipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        List groupKeys = this.check(cond);
        String where = groupKeys.stream().map(key -> "group_id=?" + AbstractJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "));
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE (");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.membership().name()).append(" WHERE ").append(where).append(") ");
        if (not) {
            query.append("AND any_id NOT IN (");
        } else {
            query.append("OR any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.dyngroupmembership().name()).append(" WHERE ").append(where).append("))");
        return query.toString();
    }

    protected String getQuery(RoleCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE (");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.role().name()).append(" WHERE ").append("role_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getRole())).append(") ");
        if (not) {
            query.append("AND any_id NOT IN (");
        } else {
            query.append("OR any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(SearchSupport.dynrolemembership().name()).append(" WHERE ").append("role_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getRole())).append("))");
        return query.toString();
    }

    protected String getQuery(PrivilegeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE (");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.priv().name()).append(" WHERE ").append("privilege_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getPrivilege())).append(") ");
        if (not) {
            query.append("AND any_id NOT IN (");
        } else {
            query.append("OR any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.dynpriv().name()).append(" WHERE ").append("privilege_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getPrivilege())).append("))");
        return query.toString();
    }

    protected String getQuery(DynRealmCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE (");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(SearchSupport.dynrealmmembership().name()).append(" WHERE ").append("dynRealm_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getDynRealm())).append("))");
        return query.toString();
    }

    protected String getQuery(ResourceCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.resource().name()).append(" WHERE resource_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getResource()));
        if (svs.anyTypeKind == AnyTypeKind.USER || svs.anyTypeKind == AnyTypeKind.ANY_OBJECT) {
            query.append(" UNION SELECT DISTINCT any_id FROM ").append(svs.groupResource().name()).append(" WHERE resource_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getResource()));
        }
        query.append(')');
        return query.toString();
    }

    protected String getQuery(MemberCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Set members = this.check(cond);
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ");
        if (not) {
            query.append("any_id NOT IN (");
        } else {
            query.append("any_id IN (");
        }
        query.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport(AnyTypeKind.USER).membership().name()).append(" WHERE ").append(members.stream().map(key -> "any_id=?" + AbstractJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(") ");
        if (not) {
            query.append("AND any_id NOT IN (");
        } else {
            query.append("OR any_id IN (");
        }
        query.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport(AnyTypeKind.ANY_OBJECT).membership().name()).append(" WHERE ").append(members.stream().map(key -> "any_id=?" + AbstractJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(')');
        return query.toString();
    }

    protected void fillAttrQuery(StringBuilder query, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        if (not && schema.isMultivalue() && !(cond instanceof AnyCond) && cond.getType() != AttrCond.Type.ISNULL && cond.getType() != AttrCond.Type.ISNOTNULL) {
            query.append("any_id NOT IN (SELECT DISTINCT any_id FROM ").append(schema.isUniqueConstraint() ? svs.asSearchViewSupport().uniqueAttr().name() : svs.asSearchViewSupport().attr().name()).append(" WHERE schema_id='").append(schema.getKey());
            this.fillAttrQuery(query, attrValue, schema, cond, false, parameters, svs);
            query.append(')');
        } else {
            Object column;
            boolean ignoreCase = AttrCond.Type.ILIKE == cond.getType() || AttrCond.Type.IEQ == cond.getType();
            Object object = column = cond instanceof AnyCond ? cond.getSchema() : AbstractJPAAnySearchDAO.key((AttrSchemaType)schema.getType());
            if (schema.getType().isStringClass() && ignoreCase) {
                column = "LOWER (" + (String)column + ")";
            }
            if (!(cond instanceof AnyCond)) {
                column = "' AND " + (String)column;
            }
            switch (cond.getType()) {
                case ISNULL: {
                    query.append((String)column).append(not ? " IS NOT NULL" : " IS NULL");
                    break;
                }
                case ISNOTNULL: {
                    query.append((String)column).append(not ? " IS NULL" : " IS NOT NULL");
                    break;
                }
                case ILIKE: 
                case LIKE: {
                    if (schema.getType().isStringClass()) {
                        query.append((String)column);
                        if (not) {
                            query.append(" NOT ");
                        }
                        query.append(" LIKE ");
                        if (ignoreCase) {
                            query.append("LOWER(?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getExpression())).append(')');
                        } else {
                            query.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getExpression()));
                        }
                        if (!this.isOracle()) break;
                        query.append(" ESCAPE '\\' ");
                        break;
                    }
                    if (!(cond instanceof AnyCond)) {
                        query.append("' AND");
                    }
                    query.append(" 1=2");
                    LOG.error("LIKE is only compatible with string or enum schemas");
                    break;
                }
                case IEQ: 
                case EQ: {
                    query.append((String)column);
                    if (not) {
                        query.append("<>");
                    } else {
                        query.append('=');
                    }
                    if (schema.getType().isStringClass() && ignoreCase) {
                        query.append("LOWER(?").append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue())).append(')');
                        break;
                    }
                    query.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
                case GE: {
                    query.append((String)column);
                    if (not) {
                        query.append('<');
                    } else {
                        query.append(">=");
                    }
                    query.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
                case GT: {
                    query.append((String)column);
                    if (not) {
                        query.append("<=");
                    } else {
                        query.append('>');
                    }
                    query.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
                case LE: {
                    query.append((String)column);
                    if (not) {
                        query.append('>');
                    } else {
                        query.append("<=");
                    }
                    query.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
                case LT: {
                    query.append((String)column);
                    if (not) {
                        query.append(">=");
                    } else {
                        query.append('<');
                    }
                    query.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
            }
        }
    }

    protected String getQuery(AttrCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Pair checked = this.check(cond, svs.anyTypeKind);
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ");
        switch (cond.getType()) {
            case ISNOTNULL: {
                query.append(((PlainSchema)checked.getLeft()).isUniqueConstraint() ? svs.asSearchViewSupport().uniqueAttr().name() : svs.asSearchViewSupport().attr().name()).append(" WHERE schema_id=").append("'").append(((PlainSchema)checked.getLeft()).getKey()).append("'");
                break;
            }
            case ISNULL: {
                query.append(svs.field().name()).append(" WHERE any_id NOT IN ").append('(').append("SELECT DISTINCT any_id FROM ").append(((PlainSchema)checked.getLeft()).isUniqueConstraint() ? svs.asSearchViewSupport().uniqueAttr().name() : svs.asSearchViewSupport().attr().name()).append(" WHERE schema_id=").append("'").append(((PlainSchema)checked.getLeft()).getKey()).append("'").append(')');
                break;
            }
            default: {
                if (not && !(cond instanceof AnyCond) && ((PlainSchema)checked.getLeft()).isMultivalue()) {
                    query.append(svs.field().name()).append(" WHERE ");
                } else {
                    query.append(((PlainSchema)checked.getLeft()).isUniqueConstraint() ? svs.asSearchViewSupport().uniqueAttr().name() : svs.asSearchViewSupport().attr().name()).append(" WHERE schema_id='").append(((PlainSchema)checked.getLeft()).getKey());
                }
                this.fillAttrQuery(query, (PlainAttrValue)checked.getRight(), (PlainSchema)checked.getLeft(), cond, not, parameters, svs);
            }
        }
        return query.toString();
    }

    protected String getQuery(AnyCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        if ("realm".equals(cond.getSchema()) && !SyncopeConstants.UUID_PATTERN.matcher(cond.getExpression()).matches()) {
            Realm realm = (Realm)this.realmSearchDAO.findByFullPath(cond.getExpression()).orElseThrow(() -> new IllegalArgumentException("Invalid Realm full path: " + cond.getExpression()));
            cond.setExpression(realm.getKey());
        }
        Triple checked = this.check(cond, svs.anyTypeKind);
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ");
        this.fillAttrQuery(query, (PlainAttrValue)checked.getMiddle(), (PlainSchema)checked.getLeft(), (AttrCond)checked.getRight(), not, parameters, svs);
        return query.toString();
    }
}

