/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.common.content.AbstractXMLContentLoader;
import org.apache.syncope.core.persistence.jpa.content.ContentLoaderHandler;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.xml.sax.helpers.DefaultHandler;

public class XMLContentLoader
extends AbstractXMLContentLoader {
    protected final DomainHolder<DataSource> domainHolder;
    protected final Resource viewsXML;
    protected final Resource indexesXML;

    public XMLContentLoader(DomainHolder<DataSource> domainHolder, Resource viewsXML, Resource indexesXML, Environment env) {
        super(env);
        this.domainHolder = domainHolder;
        this.viewsXML = viewsXML;
        this.indexesXML = indexesXML;
    }

    protected boolean existingData(String domain) {
        boolean existingData;
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)this.domainHolder.getDomains().get(domain));
        try {
            existingData = (Integer)jdbcTemplate.queryForObject("SELECT COUNT(0) FROM Realm", Integer.class) > 0;
        }
        catch (DataAccessException e) {
            LOG.error("[{}] Could not access table {}", new Object[]{domain, "Realm", e});
            existingData = true;
        }
        return existingData;
    }

    protected void createViews(String domain) throws IOException {
        LOG.debug("[{}] Creating views", (Object)domain);
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)this.domainHolder.getDomains().get(domain));
        Properties views = PropertiesLoaderUtils.loadProperties((Resource)this.viewsXML);
        views.stringPropertyNames().stream().sorted().forEach(idx -> {
            LOG.debug("[{}] Creating view {}", (Object)domain, (Object)views.get(idx).toString());
            try {
                jdbcTemplate.execute(views.getProperty((String)idx).replaceAll("\\n", " "));
            }
            catch (DataAccessException e) {
                LOG.error("[{}] Could not create view", (Object)domain, (Object)e);
            }
        });
        LOG.debug("Views created");
    }

    protected void createIndexes(String domain) throws IOException {
        LOG.debug("[{}] Creating indexes", (Object)domain);
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)this.domainHolder.getDomains().get(domain));
        Properties indexes = PropertiesLoaderUtils.loadProperties((Resource)this.indexesXML);
        indexes.stringPropertyNames().stream().sorted().forEach(idx -> {
            LOG.debug("[{}] Creating index {}", (Object)domain, (Object)indexes.get(idx).toString());
            try {
                jdbcTemplate.execute(indexes.getProperty((String)idx));
            }
            catch (DataAccessException e) {
                LOG.error("[{}] Could not create index", (Object)domain, (Object)e);
            }
        });
        LOG.debug("Indexes created");
    }

    protected void loadDefaultContent(String domain, String contentXML) throws Exception {
        InputStream in;
        try (InputStream inputStream = in = (InputStream)ApplicationContextProvider.getBeanFactory().getBean(contentXML, InputStream.class);){
            this.saxParser().parse(in, (DefaultHandler)((Object)new ContentLoaderHandler((DataSource)this.domainHolder.getDomains().get(domain), "dataset", true, this.env)));
            LOG.debug("[{}] Default content successfully loaded", (Object)domain);
        }
    }
}

