/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cxf.helpers.IOUtils;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.keymaster.client.api.model.JPADomain;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.DomainRegistry;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.apache.syncope.core.persistence.jpa.PersistenceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;

public class StartupDomainLoader
implements SyncopeCoreLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(StartupDomainLoader.class);
    protected final DomainOps domainOps;
    protected final DomainHolder<?> domainHolder;
    protected final PersistenceProperties persistenceProperties;
    protected final ResourceLoader resourceLoader;
    protected final DomainRegistry<JPADomain> domainRegistry;

    public StartupDomainLoader(DomainOps domainOps, DomainHolder<?> domainHolder, PersistenceProperties persistenceProperties, ResourceLoader resourceLoader, DomainRegistry<JPADomain> domainRegistry) {
        this.domainOps = domainOps;
        this.domainHolder = domainHolder;
        this.persistenceProperties = persistenceProperties;
        this.resourceLoader = resourceLoader;
        this.domainRegistry = domainRegistry;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void load() {
        Map<String, JPADomain> keymasterDomains = this.domainOps.list().stream().collect(Collectors.toMap(Domain::getKey, domain -> (JPADomain)domain));
        this.persistenceProperties.getDomain().stream().filter(d -> !"Master".equals(d.getKey()) && !this.domainHolder.getDomains().containsKey(d.getKey())).forEach(domainProps -> {
            if (keymasterDomains.containsKey(domainProps.getKey())) {
                LOG.info("Domain {} initialization", (Object)domainProps.getKey());
                this.domainRegistry.register((Domain)((JPADomain)keymasterDomains.get(domainProps.getKey())));
                LOG.info("Domain {} successfully inited", (Object)domainProps.getKey());
            } else {
                JPADomain.Builder builder = ((JPADomain.Builder)((JPADomain.Builder)new JPADomain.Builder(domainProps.getKey()).adminPassword(domainProps.getAdminPassword())).adminCipherAlgorithm(domainProps.getAdminCipherAlgorithm())).jdbcDriver(domainProps.getJdbcDriver()).jdbcURL(domainProps.getJdbcURL()).dbSchema(domainProps.getDbSchema()).dbUsername(domainProps.getDbUsername()).dbPassword(domainProps.getDbPassword()).databasePlatform(domainProps.getDatabasePlatform()).orm(domainProps.getOrm()).poolMaxActive(domainProps.getPoolMaxActive()).poolMinIdle(domainProps.getPoolMinIdle());
                try {
                    builder.content(IOUtils.toString((InputStream)this.resourceLoader.getResource(domainProps.getContent()).getInputStream()));
                }
                catch (IOException e) {
                    LOG.error("While loading {}", (Object)domainProps.getContent(), (Object)e);
                }
                try {
                    builder.keymasterConfParams(IOUtils.toString((InputStream)this.resourceLoader.getResource(domainProps.getKeymasterConfParams()).getInputStream()));
                }
                catch (IOException e) {
                    LOG.error("While loading {}", (Object)domainProps.getKeymasterConfParams(), (Object)e);
                }
                this.domainOps.create(builder.build());
            }
        });
    }
}

