/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.ValidationMode;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.model.JPADomain;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.DomainRegistry;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.AttrRepoDAO;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.dao.AuditEventDAO;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.BatchDAO;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.FIQLQueryDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.MailTemplateDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCJWKSDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.PersistenceInfoDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPEntityDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPEntityDAO;
import org.apache.syncope.core.persistence.api.dao.SRARouteDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.WAConfigDAO;
import org.apache.syncope.core.persistence.api.dao.keymaster.ConfParamDAO;
import org.apache.syncope.core.persistence.api.dao.keymaster.DomainDAO;
import org.apache.syncope.core.persistence.api.dao.keymaster.NetworkServiceDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.common.CommonPersistenceContext;
import org.apache.syncope.core.persistence.common.RuntimeDomainLoader;
import org.apache.syncope.core.persistence.jpa.JPADomainRegistry;
import org.apache.syncope.core.persistence.jpa.JPARuntimeDomainLoader;
import org.apache.syncope.core.persistence.jpa.PersistenceProperties;
import org.apache.syncope.core.persistence.jpa.StartupDomainLoader;
import org.apache.syncope.core.persistence.jpa.content.XMLContentExporter;
import org.apache.syncope.core.persistence.jpa.content.XMLContentLoader;
import org.apache.syncope.core.persistence.jpa.dao.AnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.JPAAnyMatchDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAuditEventDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPABatchDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAEntityCacheDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAJobStatusDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAOIDCJWKSDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPersistenceInfoDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPlainAttrValueDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPolicyDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPARealmDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPARealmSearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPATaskDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPATaskExecDAO;
import org.apache.syncope.core.persistence.jpa.dao.repo.AccessTokenRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyObjectRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyObjectRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyObjectRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyTypeClassRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyTypeClassRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyTypeClassRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyTypeRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyTypeRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyTypeRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.ApplicationRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.ApplicationRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.ApplicationRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.AttrRepoRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.AttrRepoRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.AttrRepoRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.AuditConfRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.AuthModuleRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.AuthModuleRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.AuthModuleRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.AuthProfileRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.CASSPClientAppRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.CASSPClientAppRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.CASSPClientAppRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.ConfParamRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.ConnInstanceRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.ConnInstanceRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.ConnInstanceRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.DelegationRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.DerSchemaRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.DerSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.DerSchemaRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.DomainRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.DynRealmRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.DynRealmRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.DynRealmRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.ExternalResourceRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.ExternalResourceRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.ExternalResourceRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.FIQLQueryRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.FIQLQueryRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.FIQLQueryRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.GroupRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.GroupRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.GroupRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.ImplementationRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.ImplementationRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.ImplementationRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.MailTemplateRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.NetworkServiceRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.NetworkServiceRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.NetworkServiceRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.NotificationRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.NotificationRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.NotificationRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.OIDCRPClientAppRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.OIDCRPClientAppRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.OIDCRPClientAppRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.PlainSchemaRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.PlainSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.RelationshipTypeRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.RelationshipTypeRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.RelationshipTypeRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.RemediationRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.RemediationRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.RemediationRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.ReportExecRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.ReportExecRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.ReportExecRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.ReportRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.RoleRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.RoleRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.RoleRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.SAML2IdPEntityRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.SAML2SPClientAppRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.SAML2SPClientAppRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.SAML2SPClientAppRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.SAML2SPEntityRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.SRARouteRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.SecurityQuestionRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.SecurityQuestionRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.SecurityQuestionRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.UserRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.UserRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.UserRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.VirSchemaRepo;
import org.apache.syncope.core.persistence.jpa.dao.repo.VirSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.VirSchemaRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.WAConfigRepo;
import org.apache.syncope.core.persistence.jpa.entity.task.JPATaskUtilsFactory;
import org.apache.syncope.core.persistence.jpa.spring.CommonEntityManagerFactoryConf;
import org.apache.syncope.core.persistence.jpa.spring.DomainRoutingEntityManagerFactory;
import org.apache.syncope.core.persistence.jpa.spring.MultiJarAwarePersistenceUnitPostProcessor;
import org.apache.syncope.core.persistence.jpa.spring.SyncopeJPARepository;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@EnableConfigurationProperties(value={PersistenceProperties.class})
@Import(value={CommonPersistenceContext.class})
@Configuration(proxyBeanMethods=false)
public class PersistenceContext {
    private static final Logger OPENJPA_LOG = LoggerFactory.getLogger((String)"org.apache.openjpa");

    @ConditionalOnMissingBean
    @Bean
    public CommonEntityManagerFactoryConf commonEMFConf(PersistenceProperties props, @Qualifier(value="MasterDataSource") JndiObjectFactoryBean masterDataSource) {
        CommonEntityManagerFactoryConf commonEMFConf = new CommonEntityManagerFactoryConf();
        commonEMFConf.setPackagesToScan("org.apache.syncope.core.persistence.jpa.entity");
        commonEMFConf.setValidationMode(ValidationMode.NONE);
        commonEMFConf.setPersistenceUnitPostProcessors(new MultiJarAwarePersistenceUnitPostProcessor());
        HashMap<String, Object> jpaPropertyMap = new HashMap<String, Object>();
        jpaPropertyMap.put("openjpa.Log", "slf4j");
        if (OPENJPA_LOG.isDebugEnabled()) {
            jpaPropertyMap.put("openjpa.Log", "SQL=TRACE");
            jpaPropertyMap.put("openjpa.ConnectionFactoryProperties", "PrintParameters=true, PrettyPrint=true, PrettyPrintLineLength=120");
        }
        jpaPropertyMap.put("openjpa.NontransactionalWrite", false);
        jpaPropertyMap.put("openjpa.jdbc.MappingDefaults", "ForeignKeyDeleteAction=restrict, JoinForeignKeyDeleteAction=restrict,FieldStrategies='java.util.Locale=org.apache.syncope.core.persistence.jpa.openjpa.LocaleValueHandler,java.lang.Boolean=org.apache.syncope.core.persistence.jpa.openjpa.BooleanValueHandler'");
        jpaPropertyMap.put("openjpa.DataCache", "true");
        jpaPropertyMap.put("openjpa.QueryCache", "true");
        jpaPropertyMap.put("openjpa.RemoteCommitProvider", props.getRemoteCommitProvider());
        commonEMFConf.setJpaPropertyMap(jpaPropertyMap);
        commonEMFConf.getDomains().put("Master", (DataSource)masterDataSource.getObject());
        return commonEMFConf;
    }

    @ConditionalOnMissingBean
    @Bean
    public DomainRoutingEntityManagerFactory entityManagerFactory(PersistenceProperties props, @Qualifier(value="MasterDataSource") JndiObjectFactoryBean masterDataSource, CommonEntityManagerFactoryConf commonEMFConf) {
        DomainRoutingEntityManagerFactory emf = new DomainRoutingEntityManagerFactory(commonEMFConf);
        emf.master(props, masterDataSource);
        return emf;
    }

    @ConditionalOnMissingBean
    @Bean
    public PlatformTransactionManager domainTransactionManager(EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public TransactionTemplate domainTransactionTemplate(PlatformTransactionManager domainTransactionManager) {
        return new TransactionTemplate(domainTransactionManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public XMLContentLoader xmlContentLoader(DomainHolder<DataSource> domainHolder, PersistenceProperties props, ResourceLoader resourceLoader, Environment env) {
        return new XMLContentLoader(domainHolder, resourceLoader.getResource(props.getViewsXML()), resourceLoader.getResource(props.getIndexesXML()), env);
    }

    @ConditionalOnMissingBean
    @Bean
    public XMLContentExporter xmlContentExporter(DomainHolder<DataSource> domainHolder, RealmSearchDAO realmSearchDAO, EntityManagerFactory entityManagerFactory) {
        return new XMLContentExporter(domainHolder, realmSearchDAO, entityManagerFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public DomainRegistry<JPADomain> domainRegistry(ConfigurableApplicationContext ctx) {
        return new JPADomainRegistry(ctx);
    }

    @ConditionalOnMissingBean
    @Bean
    public RuntimeDomainLoader<JPADomain> runtimeDomainLoader(DomainHolder<?> domainHolder, DomainRegistry<JPADomain> domainRegistry, DomainRoutingEntityManagerFactory entityManagerFactory, @Lazy DomainOps domainOps, ConfigurableApplicationContext ctx) {
        return new JPARuntimeDomainLoader(domainHolder, domainRegistry, entityManagerFactory, domainOps, ctx);
    }

    @ConditionalOnMissingBean
    @Bean
    public StartupDomainLoader startupDomainLoader(PersistenceProperties props, ResourceLoader resourceLoader, DomainOps domainOps, DomainHolder<?> domainHolder, DomainRegistry<JPADomain> domainRegistry) {
        return new StartupDomainLoader(domainOps, domainHolder, props, resourceLoader, domainRegistry);
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskUtilsFactory taskUtilsFactory() {
        return new JPATaskUtilsFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public EntityManager entityManager(EntityManagerFactory entityManagerFactory) {
        return SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)entityManagerFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public JpaRepositoryFactory jpaRepositoryFactory(EntityManager entityManager) {
        return new JpaRepositoryFactory(this, entityManager){

            protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
                return SyncopeJPARepository.class;
            }
        };
    }

    @ConditionalOnMissingBean
    @Bean
    public AccessTokenDAO accessTokenDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (AccessTokenDAO)jpaRepositoryFactory.getRepository(AccessTokenRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyMatchDAO anyMatchDAO(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, RealmDAO realmDAO, PlainSchemaDAO plainSchemaDAO, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityFactory entityFactory) {
        return new JPAAnyMatchDAO(userDAO, groupDAO, anyObjectDAO, realmDAO, plainSchemaDAO, anyUtilsFactory, validator, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyObjectRepoExt anyObjectRepoExt(AnyUtilsFactory anyUtilsFactory, @Lazy DynRealmDAO dynRealmDAO, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, EntityManager entityManager, AnyFinder anyFinder) {
        return new AnyObjectRepoExtImpl(anyUtilsFactory, dynRealmDAO, userDAO, groupDAO, entityManager, anyFinder);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyObjectDAO anyObjectDAO(JpaRepositoryFactory jpaRepositoryFactory, AnyObjectRepoExt anyObjectRepoExt) {
        return (AnyObjectDAO)jpaRepositoryFactory.getRepository(AnyObjectRepo.class, (Object)anyObjectRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeClassRepoExt anyTypeClassRepoExt(AnyTypeDAO anyTypeDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, @Lazy GroupDAO groupDAO, ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        return new AnyTypeClassRepoExtImpl(anyTypeDAO, plainSchemaDAO, derSchemaDAO, virSchemaDAO, groupDAO, resourceDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeClassDAO anyTypeClassDAO(JpaRepositoryFactory jpaRepositoryFactory, AnyTypeClassRepoExt anyTypeClassRepoExt) {
        return (AnyTypeClassDAO)jpaRepositoryFactory.getRepository(AnyTypeClassRepo.class, (Object)anyTypeClassRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeRepoExt anyTypeRepoExt(RemediationDAO remediationDAO, EntityManager entityManager) {
        return new AnyTypeRepoExtImpl(remediationDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeDAO anyTypeDAO(JpaRepositoryFactory jpaRepositoryFactory, AnyTypeRepoExt anyTypeRepoExt) {
        return (AnyTypeDAO)jpaRepositoryFactory.getRepository(AnyTypeRepo.class, (Object)anyTypeRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public ApplicationRepoExt applicationRepoExt(RoleDAO roleDAO, @Lazy UserDAO userDAO, EntityManager entityManager) {
        return new ApplicationRepoExtImpl(roleDAO, userDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public ApplicationDAO applicationDAO(JpaRepositoryFactory jpaRepositoryFactory, ApplicationRepoExt applicationRepoExt) {
        return (ApplicationDAO)jpaRepositoryFactory.getRepository(ApplicationRepo.class, (Object)applicationRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuditConfDAO auditConfDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (AuditConfDAO)jpaRepositoryFactory.getRepository(AuditConfRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuditEventDAO auditEventDAO(EntityManager entityManager) {
        return new JPAAuditEventDAO(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AttrRepoRepoExt attrRepoRepoExt(EntityManager entityManager) {
        return new AttrRepoRepoExtImpl(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AttrRepoDAO attrRepoDAO(JpaRepositoryFactory jpaRepositoryFactory, AttrRepoRepoExt attrRepoRepoExt) {
        return (AttrRepoDAO)jpaRepositoryFactory.getRepository(AttrRepoRepo.class, (Object)attrRepoRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthModuleRepoExt authModuleRepoExt(PolicyDAO policyDAO, EntityManager entityManager) {
        return new AuthModuleRepoExtImpl(policyDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthModuleDAO authModuleDAO(JpaRepositoryFactory jpaRepositoryFactory, AuthModuleRepoExt authModuleRepoExt) {
        return (AuthModuleDAO)jpaRepositoryFactory.getRepository(AuthModuleRepo.class, (Object)authModuleRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthProfileDAO authProfileDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (AuthProfileDAO)jpaRepositoryFactory.getRepository(AuthProfileRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public BatchDAO batchDAO(EntityManager entityManager) {
        return new JPABatchDAO(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public CASSPClientAppRepoExt casSPClientAppRepoExt(EntityManager entityManager) {
        return new CASSPClientAppRepoExtImpl(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public CASSPClientAppDAO casSPClientAppDAO(JpaRepositoryFactory jpaRepositoryFactory, CASSPClientAppRepoExt casSPClientAppRepoExt) {
        return (CASSPClientAppDAO)jpaRepositoryFactory.getRepository(CASSPClientAppRepo.class, (Object)casSPClientAppRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnInstanceRepoExt connInstanceRepoExt(@Lazy ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        return new ConnInstanceRepoExtImpl(resourceDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnInstanceDAO connInstanceDAO(JpaRepositoryFactory jpaRepositoryFactory, ConnInstanceRepoExt connInstanceRepoExt) {
        return (ConnInstanceDAO)jpaRepositoryFactory.getRepository(ConnInstanceRepo.class, (Object)connInstanceRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public DelegationDAO delegationDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (DelegationDAO)jpaRepositoryFactory.getRepository(DelegationRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public DerSchemaRepoExt derSchemaRepoExt(@Lazy ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        return new DerSchemaRepoExtImpl(resourceDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public DerSchemaDAO derSchemaDAO(JpaRepositoryFactory jpaRepositoryFactory, DerSchemaRepoExt derSchemaRepoExt) {
        return (DerSchemaDAO)jpaRepositoryFactory.getRepository(DerSchemaRepo.class, (Object)derSchemaRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public DynRealmRepoExt dynRealmRepoExt(ApplicationEventPublisher publisher, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, AnySearchDAO anySearchDAO, AnyMatchDAO anyMatchDAO, SearchCondVisitor searchCondVisitor, EntityManager entityManager) {
        return new DynRealmRepoExtImpl(publisher, userDAO, groupDAO, anyObjectDAO, anySearchDAO, anyMatchDAO, searchCondVisitor, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public DynRealmDAO dynRealmDAO(JpaRepositoryFactory jpaRepositoryFactory, DynRealmRepoExt dynRealmRepoExt) {
        return (DynRealmDAO)jpaRepositoryFactory.getRepository(DynRealmRepo.class, (Object)dynRealmRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public EntityCacheDAO entityCacheDAO(EntityManagerFactory entityManagerFactory) {
        return new JPAEntityCacheDAO(entityManagerFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public FIQLQueryRepoExt fiqlQueryRepoExt(EntityManager entityManager) {
        return new FIQLQueryRepoExtImpl(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public FIQLQueryDAO fiqlQueryDAO(JpaRepositoryFactory jpaRepositoryFactory, FIQLQueryRepoExt fiqlQueryRepoExt) {
        return (FIQLQueryDAO)jpaRepositoryFactory.getRepository(FIQLQueryRepo.class, (Object)fiqlQueryRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public GroupRepoExt groupRepoExt(ApplicationEventPublisher publisher, AnyUtilsFactory anyUtilsFactory, @Lazy PlainSchemaDAO plainSchemaDAO, @Lazy DynRealmDAO dynRealmDAO, AnyMatchDAO anyMatchDAO, @Lazy UserDAO userDAO, @Lazy AnyObjectDAO anyObjectDAO, AnySearchDAO anySearchDAO, SearchCondVisitor searchCondVisitor, EntityManager entityManager, AnyFinder anyFinder) {
        return new GroupRepoExtImpl(anyUtilsFactory, publisher, plainSchemaDAO, dynRealmDAO, anyMatchDAO, userDAO, anyObjectDAO, anySearchDAO, searchCondVisitor, entityManager, anyFinder);
    }

    @ConditionalOnMissingBean
    @Bean
    public GroupDAO groupDAO(JpaRepositoryFactory jpaRepositoryFactory, GroupRepoExt groupRepoExt) {
        return (GroupDAO)jpaRepositoryFactory.getRepository(GroupRepo.class, (Object)groupRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public ImplementationRepoExt implementationRepoExt(@Lazy ExternalResourceDAO resourceDAO, @Lazy EntityCacheDAO entityCacheDAO, EntityManager entityManager) {
        return new ImplementationRepoExtImpl(resourceDAO, entityCacheDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public ImplementationDAO implementationDAO(JpaRepositoryFactory jpaRepositoryFactory, ImplementationRepoExt implementationRepoExt) {
        return (ImplementationDAO)jpaRepositoryFactory.getRepository(ImplementationRepo.class, (Object)implementationRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public JobStatusDAO jobStatusDAO(EntityManager entityManager) {
        return new JPAJobStatusDAO(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public MailTemplateDAO mailTemplateDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (MailTemplateDAO)jpaRepositoryFactory.getRepository(MailTemplateRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationRepoExt notificationRepoExt(TaskDAO taskDAO, EntityManager entityManager) {
        return new NotificationRepoExtImpl(taskDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationDAO notificationDAO(JpaRepositoryFactory jpaRepositoryFactory, NotificationRepoExt notificationRepoExt) {
        return (NotificationDAO)jpaRepositoryFactory.getRepository(NotificationRepo.class, (Object)notificationRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public OIDCJWKSDAO oidcJWKSDAO(EntityManager entityManager) {
        return new JPAOIDCJWKSDAO(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public OIDCRPClientAppRepoExt oidcRPClientAppRepoExt(EntityManager entityManager) {
        return new OIDCRPClientAppRepoExtImpl(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public OIDCRPClientAppDAO oidcRPClientAppDAO(JpaRepositoryFactory jpaRepositoryFactory, OIDCRPClientAppRepoExt oidcRPClientAppRepoExt) {
        return (OIDCRPClientAppDAO)jpaRepositoryFactory.getRepository(OIDCRPClientAppRepo.class, (Object)oidcRPClientAppRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public PersistenceInfoDAO persistenceInfoDAO(EntityManagerFactory entityManagerFactory) {
        return new JPAPersistenceInfoDAO(entityManagerFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainAttrValueDAO plainAttrValueDAO() {
        return new JPAPlainAttrValueDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainSchemaDAO plainSchemaDAO(JpaRepositoryFactory jpaRepositoryFactory, PlainSchemaRepoExt plainSchemaRepoExt) {
        return (PlainSchemaDAO)jpaRepositoryFactory.getRepository(PlainSchemaRepo.class, (Object)plainSchemaRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public PolicyDAO policyDAO(@Lazy RealmDAO realmDAO, @Lazy ExternalResourceDAO resourceDAO, @Lazy CASSPClientAppDAO casSPClientAppDAO, @Lazy OIDCRPClientAppDAO oidcRPClientAppDAO, @Lazy SAML2SPClientAppDAO saml2SPClientAppDAO, @Lazy EntityCacheDAO entityCacheDAO, EntityManager entityManager) {
        return new JPAPolicyDAO(realmDAO, resourceDAO, casSPClientAppDAO, oidcRPClientAppDAO, saml2SPClientAppDAO, entityCacheDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public RealmDAO realmDAO(@Lazy RoleDAO roleDAO, RealmSearchDAO realmSearchDAO, ApplicationEventPublisher publisher, EntityManager entityManager) {
        return new JPARealmDAO(roleDAO, realmSearchDAO, publisher, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public RealmSearchDAO realmSearchDAO(EntityManager entityManager) {
        return new JPARealmSearchDAO(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public RelationshipTypeRepoExt relationshipTypeRepoExt(EntityManager entityManager) {
        return new RelationshipTypeRepoExtImpl(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public RelationshipTypeDAO relationshipTypeDAO(JpaRepositoryFactory jpaRepositoryFactory, RelationshipTypeRepoExt relationshipTypeRepoExt) {
        return (RelationshipTypeDAO)jpaRepositoryFactory.getRepository(RelationshipTypeRepo.class, (Object)relationshipTypeRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public RemediationRepoExt remediationRepoExt(EntityManager entityManager) {
        return new RemediationRepoExtImpl(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public RemediationDAO remediationDAO(JpaRepositoryFactory jpaRepositoryFactory, RemediationRepoExt remediationRepoExt) {
        return (RemediationDAO)jpaRepositoryFactory.getRepository(RemediationRepo.class, (Object)remediationRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportDAO reportDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (ReportDAO)jpaRepositoryFactory.getRepository(ReportRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportExecRepoExt reportExecRepoExt(EntityManager entityManager) {
        return new ReportExecRepoExtImpl(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportExecDAO reportExecDAO(JpaRepositoryFactory jpaRepositoryFactory, ReportExecRepoExt reportExecRepoExt) {
        return (ReportExecDAO)jpaRepositoryFactory.getRepository(ReportExecRepo.class, (Object)reportExecRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public ExternalResourceRepoExt resourceRepoExt(TaskDAO taskDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, VirSchemaDAO virSchemaDAO, RealmDAO realmDAO, EntityManager entityManager) {
        return new ExternalResourceRepoExtImpl(taskDAO, anyObjectDAO, userDAO, groupDAO, virSchemaDAO, realmDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public ExternalResourceDAO resourceDAO(JpaRepositoryFactory jpaRepositoryFactory, ExternalResourceRepoExt resourceRepoExt) {
        return (ExternalResourceDAO)jpaRepositoryFactory.getRepository(ExternalResourceRepo.class, (Object)resourceRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public RoleRepoExt roleRepoExt(ApplicationEventPublisher publisher, @Lazy AnyMatchDAO anyMatchDAO, @Lazy AnySearchDAO anySearchDAO, DelegationDAO delegationDAO, SearchCondVisitor searchCondVisitor, EntityManager entityManager) {
        return new RoleRepoExtImpl(publisher, anyMatchDAO, anySearchDAO, delegationDAO, searchCondVisitor, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public RoleDAO roleDAO(JpaRepositoryFactory jpaRepositoryFactory, RoleRepoExt roleRepoExt) {
        return (RoleDAO)jpaRepositoryFactory.getRepository(RoleRepo.class, (Object)roleRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2IdPEntityDAO saml2IdPEntityDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (SAML2IdPEntityDAO)jpaRepositoryFactory.getRepository(SAML2IdPEntityRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2SPClientAppRepoExt saml2SPClientAppRepoExt(EntityManager entityManager) {
        return new SAML2SPClientAppRepoExtImpl(entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2SPClientAppDAO saml2SPClientAppDAO(JpaRepositoryFactory jpaRepositoryFactory, SAML2SPClientAppRepoExt saml2SPClientAppRepoExt) {
        return (SAML2SPClientAppDAO)jpaRepositoryFactory.getRepository(SAML2SPClientAppRepo.class, (Object)saml2SPClientAppRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2SPEntityDAO saml2SPEntityDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (SAML2SPEntityDAO)jpaRepositoryFactory.getRepository(SAML2SPEntityRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public SecurityQuestionRepoExt securityQuestionRepoExt(UserDAO userDAO, EntityManager entityManager) {
        return new SecurityQuestionRepoExtImpl(userDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public SecurityQuestionDAO securityQuestionDAO(JpaRepositoryFactory jpaRepositoryFactory, SecurityQuestionRepoExt securityQuestionRepoExt) {
        return (SecurityQuestionDAO)jpaRepositoryFactory.getRepository(SecurityQuestionRepo.class, (Object)securityQuestionRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public SRARouteDAO sraRouteDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (SRARouteDAO)jpaRepositoryFactory.getRepository(SRARouteRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskDAO taskDAO(RealmSearchDAO realmSearchDAO, RemediationDAO remediationDAO, TaskUtilsFactory taskUtilsFactory, SecurityProperties securityProperties, EntityManager entityManager) {
        return new JPATaskDAO(realmSearchDAO, remediationDAO, taskUtilsFactory, securityProperties, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskExecDAO taskExecDAO(TaskDAO taskDAO, TaskUtilsFactory taskUtilsFactory, EntityManager entityManager) {
        return new JPATaskExecDAO(taskDAO, taskUtilsFactory, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserRepoExt userRepoExt(SecurityProperties securityProperties, AnyUtilsFactory anyUtilsFactory, @Lazy DynRealmDAO dynRealmDAO, RoleDAO roleDAO, AccessTokenDAO accessTokenDAO, @Lazy GroupDAO groupDAO, DelegationDAO delegationDAO, FIQLQueryDAO fiqlQueryDAO, EntityManager entityManager, AnyFinder anyFinder) {
        return new UserRepoExtImpl(anyUtilsFactory, dynRealmDAO, roleDAO, accessTokenDAO, groupDAO, delegationDAO, fiqlQueryDAO, securityProperties, entityManager, anyFinder);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserDAO userDAO(JpaRepositoryFactory jpaRepositoryFactory, UserRepoExt userRepoExt) {
        return (UserDAO)jpaRepositoryFactory.getRepository(UserRepo.class, (Object)userRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public VirSchemaRepoExt virSchemaRepoExt(@Lazy ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        return new VirSchemaRepoExtImpl(resourceDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public VirSchemaDAO virSchemaDAO(JpaRepositoryFactory jpaRepositoryFactory, VirSchemaRepoExt virSchemaRepoExt) {
        return (VirSchemaDAO)jpaRepositoryFactory.getRepository(VirSchemaRepo.class, (Object)virSchemaRepoExt);
    }

    @ConditionalOnMissingBean
    @Bean
    public WAConfigDAO waConfigDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (WAConfigDAO)jpaRepositoryFactory.getRepository(WAConfigRepo.class);
    }

    @Bean
    public ConfParamDAO confParamDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (ConfParamDAO)jpaRepositoryFactory.getRepository(ConfParamRepo.class);
    }

    @Bean
    public DomainDAO domainDAO(JpaRepositoryFactory jpaRepositoryFactory) {
        return (DomainDAO)jpaRepositoryFactory.getRepository(DomainRepo.class);
    }

    @ConditionalOnMissingBean
    @Bean
    public NetworkServiceRepoExt networkServiceRepoExt(EntityManager entityManager) {
        return new NetworkServiceRepoExtImpl(entityManager);
    }

    @Bean
    public NetworkServiceDAO networkServiceDAO(JpaRepositoryFactory jpaRepositoryFactory, NetworkServiceRepoExt networkServiceRepoExt) {
        return (NetworkServiceDAO)jpaRepositoryFactory.getRepository(NetworkServiceRepo.class, (Object)networkServiceRepoExt);
    }
}

