/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.jpa.dao.AnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.PGAnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.PGJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.repo.PGPlainSchemaRepoExtImpl;
import org.apache.syncope.core.persistence.jpa.dao.repo.PlainSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.PGEntityFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"org.postgresql.Driver"})
public class PGPersistenceContext {
    @ConditionalOnMissingBean
    @Bean
    public EntityFactory entityFactory() {
        return new PGEntityFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyFinder anyFinder(@Lazy PlainSchemaDAO plainSchemaDAO, EntityManager entityManager) {
        return new PGAnyFinder(plainSchemaDAO, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnySearchDAO anySearchDAO(@Lazy RealmSearchDAO realmSearchDAO, @Lazy DynRealmDAO dynRealmDAO, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, @Lazy PlainSchemaDAO schemaDAO, @Lazy EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        return new PGJPAAnySearchDAO(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainSchemaRepoExt plainSchemaRepoExt(AnyUtilsFactory anyUtilsFactory, @Lazy ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        return new PGPlainSchemaRepoExtImpl(anyUtilsFactory, resourceDAO, entityManager);
    }
}

