/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.oidc;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.OIDCC4UIProviderTO;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIProvider;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.metadata.OidcOpMetadataResolver;
import org.pac4j.oidc.metadata.StaticOidcOpMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientCache {
    protected static final Logger LOG = LoggerFactory.getLogger(OIDCClientCache.class);
    protected static final Function<String, String> DISCOVERY_URI = issuer -> issuer + "/.well-known/openid-configuration";
    protected final List<OidcClient> cache = Collections.synchronizedList(new ArrayList());

    public static void importMetadata(OIDCC4UIProviderTO opTO) throws IOException, InterruptedException, ParseException {
        String discoveryDocumentURI = DISCOVERY_URI.apply(opTO.getIssuer());
        HttpResponse<String> response = HttpClient.newBuilder().build().send(HttpRequest.newBuilder(URI.create(discoveryDocumentURI)).GET().build(), HttpResponse.BodyHandlers.ofString());
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)response.body());
        opTO.setIssuer((String)Optional.ofNullable(metadata.getIssuer()).map(Identifier::getValue).orElse(null));
        opTO.setJwksUri((String)Optional.ofNullable(metadata.getJWKSetURI()).map(URI::toASCIIString).orElse(null));
        opTO.setAuthorizationEndpoint((String)Optional.ofNullable(metadata.getAuthorizationEndpointURI()).map(URI::toASCIIString).orElse(null));
        opTO.setTokenEndpoint((String)Optional.ofNullable(metadata.getTokenEndpointURI()).map(URI::toASCIIString).orElse(null));
        opTO.setUserinfoEndpoint((String)Optional.ofNullable(metadata.getUserInfoEndpointURI()).map(URI::toASCIIString).orElse(null));
        opTO.setEndSessionEndpoint((String)Optional.ofNullable(metadata.getEndSessionEndpointURI()).map(URI::toASCIIString).orElse(null));
        Optional.ofNullable(metadata.getScopes()).ifPresent(s -> opTO.getScopes().addAll(s.toStringList()));
    }

    public Optional<OidcClient> get(String opName) {
        return this.cache.stream().filter(c -> opName.equals(c.getName())).findFirst();
    }

    public OidcClient add(OIDCC4UIProvider op, String callbackUrl) {
        OIDCProviderMetadata metadata = new OIDCProviderMetadata(new Issuer(op.getIssuer()), List.of(SubjectType.PUBLIC), (URI)Optional.ofNullable(op.getJwksUri()).map(URI::create).orElse(null));
        metadata.setIDTokenJWSAlgs(List.of(JWSAlgorithm.HS256));
        metadata.setAuthorizationEndpointURI((URI)Optional.ofNullable(op.getAuthorizationEndpoint()).map(URI::create).orElse(null));
        metadata.setTokenEndpointURI((URI)Optional.ofNullable(op.getTokenEndpoint()).map(URI::create).orElse(null));
        metadata.setUserInfoEndpointURI((URI)Optional.ofNullable(op.getUserinfoEndpoint()).map(URI::create).orElse(null));
        metadata.setEndSessionEndpointURI((URI)Optional.ofNullable(op.getEndSessionEndpoint()).map(URI::create).orElse(null));
        OidcConfiguration cfg = new OidcConfiguration();
        cfg.setClientId(op.getClientID());
        cfg.setSecret(op.getClientSecret());
        cfg.setDiscoveryURI(DISCOVERY_URI.apply(op.getIssuer()));
        cfg.setPreferredJwsAlgorithm(JWSAlgorithm.HS256);
        cfg.setOpMetadataResolver((OidcOpMetadataResolver)new StaticOidcOpMetadataResolver(cfg, metadata));
        cfg.setScope(op.getScopes().stream().collect(Collectors.joining(" ")));
        cfg.setUseNonce(false);
        OidcClient client = new OidcClient(cfg);
        client.setName(op.getName());
        client.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
        client.setCallbackUrl(callbackUrl);
        client.init();
        this.cache.add(client);
        return client;
    }

    public boolean removeAll(String opName) {
        return this.cache.removeIf(c -> opName.equals(c.getName()));
    }
}

