/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v11.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.tirasa.connid.bundles.scim.common.dto.AbstractSCIMUser;
import net.tirasa.connid.bundles.scim.common.dto.BaseResourceReference;
import net.tirasa.connid.bundles.scim.common.dto.SCIMDefaultComplex;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11EnterpriseUser;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Meta;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;

public class SCIMv11User
extends AbstractSCIMUser<SCIMv11Attribute, SCIMDefaultComplex, BaseResourceReference, SCIMv11Meta, SCIMv11EnterpriseUser> {
    private static final long serialVersionUID = -6868285123690771711L;
    @JsonProperty(value="urn:scim:schemas:extension:enterprise:1.0")
    protected SCIMv11EnterpriseUser enterpriseUser;

    @Override
    protected void handleRoles(Object value) {
        this.handleSCIMDefaultObject((String)String.class.cast(value), this.roles, s -> s.setValue((String)String.class.cast(value)));
    }

    @Override
    protected void handlex509Certificates(Object value) {
        this.handleSCIMDefaultObject((String)String.class.cast(value), this.x509Certificates, s -> s.setValue((String)String.class.cast(value)));
    }

    @Override
    protected void handleDefaultEntitlement(Object value) {
        this.handleBaseResourceReference((String)String.class.cast(value), this.entitlements, s -> s.setValue((String)String.class.cast(value)));
    }

    @Override
    @JsonIgnore
    public void fillSCIMCustomAttributes(Set<Attribute> attributes, String customAttributesJSON) {
        SCIMUtils.extractSCIMSchemas(customAttributesJSON, SCIMv11Attribute.class).ifPresent(customAttributesObj -> {
            block0: for (Attribute attribute : attributes) {
                if (CollectionUtil.isEmpty((Collection)attribute.getValue())) continue;
                for (SCIMv11Attribute customAttribute : customAttributesObj.getAttributes()) {
                    String externalAttributeName = customAttribute.getSchema().concat(".").concat(customAttribute.getName());
                    if (!externalAttributeName.equals(attribute.getName())) continue;
                    this.scimCustomAttributes.put(customAttribute, attribute.getValue());
                    continue block0;
                }
            }
        });
    }

    @Override
    public SCIMv11EnterpriseUser getEnterpriseUser() {
        return this.enterpriseUser;
    }

    @Override
    public void setEnterpriseUser(SCIMv11EnterpriseUser enterpriseUser) {
        this.enterpriseUser = enterpriseUser;
    }

    @Override
    public void fillEnterpriseUser(Set<Attribute> attributes) {
        this.enterpriseUser = new SCIMv11EnterpriseUser();
        attributes.stream().filter(a -> a.getName().startsWith("urn:scim:schemas:extension:enterprise:1.0")).forEach(a -> {
            switch (a.getName().replace("urn:scim:schemas:extension:enterprise:1.0.", "")) {
                case "employeeNumber": {
                    this.enterpriseUser.setEmployeeNumber(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "manager.managerId": {
                    SCIMv11EnterpriseUser.SCIMv11EnterpriseUserManager manager = this.enterpriseUser.getManager();
                    if (manager == null) {
                        manager = new SCIMv11EnterpriseUser.SCIMv11EnterpriseUserManager();
                        this.enterpriseUser.setManager(manager);
                    }
                    manager.setManagerId(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "manager.displayName": {
                    SCIMv11EnterpriseUser.SCIMv11EnterpriseUserManager manager = this.enterpriseUser.getManager();
                    if (manager == null) {
                        manager = new SCIMv11EnterpriseUser.SCIMv11EnterpriseUserManager();
                        this.enterpriseUser.setManager(manager);
                    }
                    manager.setDisplayName(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
            }
        });
    }

    @JsonIgnore
    private void handleSCIMDefaultObject(String value, List<SCIMDefaultComplex> list, Consumer<SCIMDefaultComplex> setter) {
        SCIMDefaultComplex selected = null;
        for (SCIMDefaultComplex scimDefault : list) {
            if (!scimDefault.getValue().equals(value)) continue;
            selected = scimDefault;
            break;
        }
        if (selected == null) {
            selected = new SCIMDefaultComplex();
            list.add(selected);
        }
        setter.accept(selected);
    }

    @JsonIgnore
    private void handleBaseResourceReference(String value, List<BaseResourceReference> list, Consumer<BaseResourceReference> setter) {
        BaseResourceReference selected = null;
        for (BaseResourceReference scimDefault : list) {
            if (!scimDefault.getValue().equals(value)) continue;
            selected = scimDefault;
            break;
        }
        if (selected == null) {
            selected = new BaseResourceReference();
            list.add(selected);
        }
        setter.accept(selected);
    }

    @Override
    protected void entitlementsToAttribute(List<BaseResourceReference> entitlementRefs, Set<Attribute> attrs) {
        if (!entitlementRefs.isEmpty()) {
            attrs.add(AttributeBuilder.build((String)"entitlements.default.value", (Object[])new Object[]{entitlementRefs.get(0).getValue()}));
        }
    }
}

