/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509ExtractorUtils;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CommonNameEDIPIPrincipalResolver
extends AbstractX509PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509CommonNameEDIPIPrincipalResolver.class);

    public X509CommonNameEDIPIPrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        String subjectDn = certificate.getSubjectDN().getName();
        LOGGER.debug("Creating principal based on subject DN [{}]", (Object)subjectDn);
        if (StringUtils.isBlank((CharSequence)subjectDn)) {
            return this.getAlternatePrincipal(certificate);
        }
        String commonName = X509ExtractorUtils.retrieveTheCommonName(subjectDn);
        if (StringUtils.isBlank((CharSequence)commonName)) {
            return this.getAlternatePrincipal(certificate);
        }
        Optional<String> result = X509ExtractorUtils.retrieveTheEDIPI(commonName);
        if (result.isEmpty()) {
            return this.getAlternatePrincipal(certificate);
        }
        LOGGER.debug("Final principal id extracted from [{}] is [{}]", (Object)subjectDn, (Object)result.get());
        return result.get();
    }

    @Override
    @Generated
    public String toString() {
        return "X509CommonNameEDIPIPrincipalResolver(super=" + super.toString() + ")";
    }
}

