/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.HttpClientProperties;
import org.apereo.cas.configuration.model.core.web.MessageBundleProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.web.support.MappedExceptionErrorViewResolver;
import org.apereo.cas.util.spring.RestActuatorControllerEndpoint;
import org.apereo.cas.util.spring.RestActuatorEndpointDiscoverer;
import org.apereo.cas.util.spring.RestActuatorEndpointHandlerMapping;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.CasYamlHttpMessageConverter;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.apereo.cas.web.view.CasReloadableMessageBundle;
import org.apereo.cas.web.view.DynamicHtmlView;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.CorsEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.webflow.conversation.NoSuchConversationException;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Core})
@Configuration(value="CasCoreWebConfiguration", proxyBeanMethods=false)
class CasCoreWebConfiguration {
    CasCoreWebConfiguration() {
    }

    @Configuration(value="CasCoreWebEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class, CorsEndpointProperties.class, WebProperties.class})
    static class CasCoreWebEndpointsConfiguration {
        CasCoreWebEndpointsConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casProtocolEndpointConfigurer"})
        public CasWebSecurityConfigurer<Void> casProtocolEndpointConfigurer() {
            return new CasWebSecurityConfigurer<Void>(this){

                public List<String> getIgnoredEndpoints() {
                    return List.of(org.apache.commons.lang3.StringUtils.prependIfMissing((String)"/login", (CharSequence)"/", (CharSequence[])new CharSequence[0]), org.apache.commons.lang3.StringUtils.prependIfMissing((String)"/logout", (CharSequence)"/", (CharSequence[])new CharSequence[0]), org.apache.commons.lang3.StringUtils.prependIfMissing((String)"/validate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), org.apache.commons.lang3.StringUtils.prependIfMissing((String)"/serviceValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), org.apache.commons.lang3.StringUtils.prependIfMissing((String)"/p3/serviceValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), org.apache.commons.lang3.StringUtils.prependIfMissing((String)"/proxyValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), org.apache.commons.lang3.StringUtils.prependIfMissing((String)"/p3/proxyValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), org.apache.commons.lang3.StringUtils.prependIfMissing((String)"/proxy", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean(name={"restControllerEndpointDiscoverer"})
        public RestActuatorEndpointDiscoverer restControllerEndpointDiscoverer(ConfigurableApplicationContext applicationContext, ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<Collection<EndpointFilter<RestActuatorControllerEndpoint>>> filters) {
            return new RestActuatorEndpointDiscoverer((ApplicationContext)applicationContext, endpointPathMappers.orderedStream().toList(), (Collection)filters.getIfAvailable(Collections::emptyList));
        }

        @Bean
        public WebMvcEndpointHandlerMapping webEndpointServletHandlerMapping(EndpointLinksResolver endpointLinksResolver, WebEndpointsSupplier webEndpointsSupplier, EndpointsSupplier<RestActuatorControllerEndpoint> restEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, Environment environment) {
            Collection webEndpoints = webEndpointsSupplier.getEndpoints();
            String basePath = webEndpointProperties.getBasePath();
            EndpointMapping endpointMapping = new EndpointMapping(basePath);
            boolean shouldRegisterLinksMapping = CasCoreWebEndpointsConfiguration.shouldRegisterLinksMapping(webEndpointProperties, environment, basePath);
            return new WebMvcEndpointHandlerMapping(endpointMapping, webEndpoints, endpointMediaTypes, corsProperties.toCorsConfiguration(), endpointLinksResolver, shouldRegisterLinksMapping);
        }

        @Bean
        public EndpointLinksResolver endpointLinksResolver(WebEndpointsSupplier webEndpointsSupplier, EndpointsSupplier<RestActuatorControllerEndpoint> restEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties) {
            String basePath = webEndpointProperties.getBasePath();
            ArrayList allEndpoints = new ArrayList();
            Collection webEndpoints = webEndpointsSupplier.getEndpoints();
            allEndpoints.addAll(webEndpoints);
            allEndpoints.addAll(restEndpointsSupplier.getEndpoints());
            return new EndpointLinksResolver(allEndpoints, basePath);
        }

        @Bean
        @ConditionalOnMissingBean(name={"restControllerEndpointHandlerMapping"})
        public RestActuatorEndpointHandlerMapping restControllerEndpointHandlerMapping(EndpointsSupplier<RestActuatorControllerEndpoint> restEndpointsSupplier, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties) {
            EndpointMapping endpointMapping = new EndpointMapping(webEndpointProperties.getBasePath());
            return new RestActuatorEndpointHandlerMapping(endpointMapping, restEndpointsSupplier.getEndpoints(), corsProperties.toCorsConfiguration());
        }

        private static boolean shouldRegisterLinksMapping(WebEndpointProperties webEndpointProperties, Environment environment, String basePath) {
            return webEndpointProperties.getDiscovery().isEnabled() && (StringUtils.hasText((String)basePath) || ManagementPortType.get((Environment)environment) == ManagementPortType.DIFFERENT);
        }
    }

    @Configuration(value="CasCoreWebViewsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebViewsConfiguration {
        CasCoreWebViewsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"dynamicHtmlView"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View dynamicHtmlView() {
            return (model, request, response) -> {
                String html = (String)Objects.requireNonNull(model).get(DynamicHtmlView.class.getName());
                new DynamicHtmlView(html).render(model, request, response);
            };
        }
    }

    @Configuration(value="CasCoreWebRequestsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebRequestsConfiguration {
        CasCoreWebRequestsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"argumentExtractor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ArgumentExtractor argumentExtractor(List<ServiceFactoryConfigurer> configurers) {
            AnnotationAwareOrderComparator.sortIfNecessary(configurers);
            ArrayList serviceFactoryList = configurers.stream().flatMap(configurer -> configurer.buildServiceFactories().stream()).collect(Collectors.toCollection(ArrayList::new));
            return new DefaultArgumentExtractor((List)serviceFactoryList);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"urlValidator"})
        public FactoryBean<UrlValidator> urlValidator(CasConfigurationProperties casProperties) {
            HttpClientProperties httpClient = casProperties.getHttpClient();
            boolean allowLocalLogoutUrls = httpClient.isAllowLocalUrls();
            String authorityValidationRegEx = httpClient.getAuthorityValidationRegex();
            boolean authorityValidationRegExCaseSensitive = httpClient.isAuthorityValidationRegExCaseSensitive();
            return new SimpleUrlValidatorFactoryBean(allowLocalLogoutUrls, authorityValidationRegEx, authorityValidationRegExCaseSensitive);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"yamlHttpMessageConverter"})
        public HttpMessageConverter yamlHttpMessageConverter() {
            return new CasYamlHttpMessageConverter();
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultMappedExceptionErrorViewResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ErrorViewResolver defaultMappedExceptionErrorViewResolver(WebProperties webProperties, ConfigurableApplicationContext applicationContext) {
            Map<Class<NoSuchConversationException>, ModelAndView> mappings = Map.of(UnauthorizedServiceException.class, CasCoreWebRequestsConfiguration.getModelAndView(HttpStatus.FORBIDDEN, "error/casServiceErrorView"), NoSuchConversationException.class, CasCoreWebRequestsConfiguration.getModelAndView(HttpStatus.UNPROCESSABLE_ENTITY, "error/%s".formatted(HttpStatus.UNPROCESSABLE_ENTITY.value())));
            return new MappedExceptionErrorViewResolver((ApplicationContext)applicationContext, webProperties.getResources(), mappings, errorContext -> Optional.empty());
        }

        private static ModelAndView getModelAndView(HttpStatus status, String viewName) {
            ModelAndView mv = new ModelAndView();
            mv.setStatus(HttpStatusCode.valueOf((int)status.value()));
            mv.setViewName(viewName);
            return mv;
        }
    }

    @Configuration(value="CasCoreWebMessageSourceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebMessageSourceConfiguration {
        CasCoreWebMessageSourceConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PropertiesFactoryBean casCommonMessages(CasConfigurationProperties casProperties) {
            PropertiesFactoryBean properties = new PropertiesFactoryBean();
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            List commonNames = casProperties.getMessageBundle().getCommonNames();
            List resourceList = commonNames.stream().map(arg_0 -> ((DefaultResourceLoader)resourceLoader).getResource(arg_0)).collect(Collectors.toList());
            resourceList.add(resourceLoader.getResource("classpath:/cas_common_messages.properties"));
            properties.setLocations((Resource[])resourceList.toArray(Resource[]::new));
            properties.setSingleton(true);
            properties.setIgnoreResourceNotFound(true);
            return properties;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public HierarchicalMessageSource messageSource(CasConfigurationProperties casProperties, @Qualifier(value="casCommonMessages") Properties casCommonMessages) {
            CasReloadableMessageBundle bean = new CasReloadableMessageBundle();
            MessageBundleProperties mb = casProperties.getMessageBundle();
            bean.setDefaultEncoding(mb.getEncoding());
            bean.setCacheSeconds(Long.valueOf(Beans.newDuration((String)mb.getCacheSeconds()).toSeconds()).intValue());
            bean.setFallbackToSystemLocale(mb.isFallbackSystemLocale());
            bean.setUseCodeAsDefaultMessage(mb.isUseCodeMessage());
            bean.setBasenames(mb.getBaseNames().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
            bean.setCommonMessages(casCommonMessages);
            return bean;
        }
    }
}

