/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.rest.api.service;

import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.List;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.types.CipherAlgorithm;

@Tag(name="Domains")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication")})
@Path(value="domains")
public interface DomainService
extends Serializable {
    @GET
    @Produces(value={"application/json"})
    public List<Domain> list();

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public Domain read(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="201", description="Domain successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="Key of the domin created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the domin created")})})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(Domain var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="{key}/deployed")
    @Produces(value={"application/json"})
    public void deployed(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="{key}/changeAdminPassword")
    @Produces(value={"application/json"})
    public void changeAdminPassword(@NotNull @PathParam(value="key") String var1, @QueryParam(value="password") String var2, @QueryParam(value="cipherAlgorithm") CipherAlgorithm var3);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="{key}/adjustPoolSize")
    @Produces(value={"application/json"})
    public void adjustPoolSize(@NotNull @PathParam(value="key") String var1, @QueryParam(value="poolMaxActive") int var2, @QueryParam(value="poolMinIdle") int var3);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public void delete(@NotNull @PathParam(value="key") String var1);
}

