/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.pac4j.saml;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.syncope.common.lib.to.SAML2SPEntityTO;
import org.apache.syncope.common.rest.api.service.SAML2SPEntityService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.pac4j.saml.WASAML2MetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASAML2ClientMetadataGenerator
extends BaseSAML2MetadataGenerator {
    protected static final Logger LOG = LoggerFactory.getLogger(WASAML2ClientMetadataGenerator.class);
    protected final WARestClient waRestClient;
    protected final SAML2Client saml2Client;

    public WASAML2ClientMetadataGenerator(WARestClient waRestClient, SAML2Client saml2Client) {
        this.waRestClient = waRestClient;
        this.saml2Client = saml2Client;
    }

    public boolean storeMetadata(String metadata, boolean force) {
        return true;
    }

    protected AbstractMetadataResolver createMetadataResolver() {
        return new WASAML2MetadataResolver(this.waRestClient, this.saml2Client);
    }

    public MetadataResolver buildMetadataResolver() throws Exception {
        SAML2SPEntityTO entityTO;
        String encodedMetadata = Base64.getEncoder().encodeToString(this.getMetadata(this.buildEntityDescriptor()).getBytes(StandardCharsets.UTF_8));
        try {
            entityTO = ((SAML2SPEntityService)this.waRestClient.getService(SAML2SPEntityService.class)).get(this.saml2Client.getName());
            entityTO.setMetadata(encodedMetadata);
        }
        catch (Exception e) {
            LOG.debug("SP Entity {} not found, creating new", (Object)this.saml2Client.getName(), (Object)e);
            entityTO = (SAML2SPEntityTO)((SAML2SPEntityTO.Builder)new SAML2SPEntityTO.Builder().key(this.saml2Client.getName())).metadata(encodedMetadata).build();
        }
        LOG.debug("Storing SP Entity {}", (Object)entityTO);
        ((SAML2SPEntityService)this.waRestClient.getService(SAML2SPEntityService.class)).set(entityTO);
        return super.buildMetadataResolver();
    }
}

