/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.Optional;
import org.apache.syncope.common.lib.policy.DefaultTicketExpirationPolicyConf;
import org.apache.syncope.common.lib.policy.TicketExpirationPolicyConf;
import org.apache.syncope.common.lib.policy.TicketExpirationPolicyTO;
import org.apache.syncope.wa.starter.mapping.TicketExpirationMapper;
import org.apereo.cas.services.DefaultRegisteredServiceProxyGrantingTicketExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProxyGrantingTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;

public class DefaultTicketExpirationMapper
implements TicketExpirationMapper {
    @Override
    public boolean supports(TicketExpirationPolicyConf conf) {
        return DefaultTicketExpirationPolicyConf.class.equals((Object)conf.getClass());
    }

    protected Optional<DefaultTicketExpirationPolicyConf> conf(TicketExpirationPolicyTO policy) {
        if (policy.getConf() instanceof DefaultTicketExpirationPolicyConf) {
            return Optional.of((DefaultTicketExpirationPolicyConf)policy.getConf());
        }
        return Optional.empty();
    }

    @Override
    public RegisteredServiceTicketGrantingTicketExpirationPolicy buildTGT(TicketExpirationPolicyTO policy) {
        return this.conf(policy).flatMap(conf -> Optional.ofNullable(conf.getTgtConf())).map(conf -> {
            DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy result = new DefaultRegisteredServiceTicketGrantingTicketExpirationPolicy();
            result.setMaxTimeToLiveInSeconds(conf.getMaxTimeToLiveInSeconds());
            return result;
        }).orElse(null);
    }

    @Override
    public RegisteredServiceServiceTicketExpirationPolicy buildST(TicketExpirationPolicyTO policy) {
        return this.conf(policy).flatMap(conf -> Optional.ofNullable(conf.getStConf())).map(conf -> {
            DefaultRegisteredServiceServiceTicketExpirationPolicy result = new DefaultRegisteredServiceServiceTicketExpirationPolicy();
            result.setNumberOfUses(conf.getNumberOfUses());
            result.setTimeToLive(Long.toString(conf.getMaxTimeToLiveInSeconds()));
            return result;
        }).orElse(null);
    }

    @Override
    public RegisteredServiceProxyGrantingTicketExpirationPolicy buildProxyTGT(TicketExpirationPolicyTO policy) {
        return this.conf(policy).flatMap(conf -> Optional.ofNullable(conf.getProxyTgtConf())).map(conf -> {
            DefaultRegisteredServiceProxyGrantingTicketExpirationPolicy result = new DefaultRegisteredServiceProxyGrantingTicketExpirationPolicy();
            result.setMaxTimeToLiveInSeconds(conf.getMaxTimeToLiveInSeconds());
            return result;
        }).orElse(null);
    }

    @Override
    public RegisteredServiceProxyTicketExpirationPolicy buildProxyST(TicketExpirationPolicyTO policy) {
        return this.conf(policy).flatMap(conf -> Optional.ofNullable(conf.getProxyStConf())).map(conf -> {
            DefaultRegisteredServiceProxyTicketExpirationPolicy result = new DefaultRegisteredServiceProxyTicketExpirationPolicy();
            result.setNumberOfUses(conf.getNumberOfUses());
            result.setTimeToLive(Long.toString(conf.getMaxTimeToLiveInSeconds()));
            return result;
        }).orElse(null);
    }
}

