/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.gauth;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.common.rest.api.service.wa.GoogleMfaAuthAccountService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.gauth.WAGoogleMfaAuthTokenRepository;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAGoogleMfaAuthCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    protected static final Logger LOG = LoggerFactory.getLogger(WAGoogleMfaAuthTokenRepository.class);
    protected final WARestClient waRestClient;

    public WAGoogleMfaAuthCredentialRepository(WARestClient waRestClient, IGoogleAuthenticator googleAuthenticator) {
        super(CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber(), googleAuthenticator);
        this.waRestClient = waRestClient;
    }

    protected GoogleMfaAuthAccount mapGoogleMfaAuthAccount(OneTimeTokenAccount otta) {
        return new GoogleMfaAuthAccount.Builder().registrationDate(OffsetDateTime.now()).scratchCodes(otta.getScratchCodes().stream().map(Number::intValue).toList()).validationCode(Integer.valueOf(otta.getValidationCode())).secretKey(otta.getSecretKey()).id(Long.valueOf(otta.getId())).build();
    }

    protected GoogleAuthenticatorAccount mapGoogleMfaAuthAccount(GoogleMfaAuthAccount gmfaa) {
        return ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().secretKey(gmfaa.getSecretKey())).validationCode(gmfaa.getValidationCode())).scratchCodes(gmfaa.getScratchCodes().stream().map(Number::intValue).collect(Collectors.toList()))).name(gmfaa.getName())).id(gmfaa.getId())).build();
    }

    protected GoogleMfaAuthAccountService service() {
        return (GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class);
    }

    public OneTimeTokenAccount get(long id) {
        try {
            GoogleMfaAuthAccount account = this.service().read(id);
            if (account != null) {
                return this.mapGoogleMfaAuthAccount(account);
            }
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for id {}", (Object)id);
            }
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public OneTimeTokenAccount get(String username, long id) {
        try {
            return this.service().read(username).getResult().stream().filter(account -> account.getId() == id).map(this::mapGoogleMfaAuthAccount).findFirst().orElse(null);
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {} and id {}", (Object)username, (Object)id);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public Collection<? extends OneTimeTokenAccount> get(String username) {
        try {
            return this.service().read(username).getResult().stream().map(this::mapGoogleMfaAuthAccount).toList();
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {}", (Object)username);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return List.of();
        }
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        return this.service().list().getResult().stream().map(this::mapGoogleMfaAuthAccount).toList();
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount otta) {
        GoogleMfaAuthAccount account = new GoogleMfaAuthAccount.Builder().registrationDate(OffsetDateTime.now()).scratchCodes(otta.getScratchCodes().stream().map(Number::intValue).toList()).validationCode(Integer.valueOf(otta.getValidationCode())).secretKey(otta.getSecretKey()).name(otta.getName()).id(Long.valueOf(otta.getId())).build();
        this.service().create(otta.getUsername(), account);
        return this.mapGoogleMfaAuthAccount(account);
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount tokenAccount) {
        GoogleMfaAuthAccount acct = this.mapGoogleMfaAuthAccount(tokenAccount);
        this.service().update(tokenAccount.getUsername(), acct);
        return tokenAccount;
    }

    public void deleteAll() {
        this.service().deleteAll();
    }

    public void delete(String username) {
        try {
            this.service().delete(username);
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {}", (Object)username);
            }
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(long id) {
        this.service().delete(id);
    }

    public long count() {
        return this.service().list().getTotalCount();
    }

    public long count(String username) {
        try {
            return this.service().read(username).getTotalCount();
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {}", (Object)username);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0L;
        }
    }
}

