/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStart;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStop;
import org.apache.syncope.wa.bootstrap.WAProperties;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.bootstrap.mapping.AttrReleaseMapper;
import org.apache.syncope.wa.starter.actuate.SyncopeCoreHealthIndicator;
import org.apache.syncope.wa.starter.actuate.SyncopeWAInfoContributor;
import org.apache.syncope.wa.starter.audit.WAAuditTrailManager;
import org.apache.syncope.wa.starter.events.WAEventRepository;
import org.apache.syncope.wa.starter.gauth.WAGoogleMfaAuthCredentialRepository;
import org.apache.syncope.wa.starter.gauth.WAGoogleMfaAuthTokenRepository;
import org.apache.syncope.wa.starter.mapping.AccessMapper;
import org.apache.syncope.wa.starter.mapping.AuthMapper;
import org.apache.syncope.wa.starter.mapping.CASSPClientAppTOMapper;
import org.apache.syncope.wa.starter.mapping.ClientAppMapper;
import org.apache.syncope.wa.starter.mapping.DefaultAccessMapper;
import org.apache.syncope.wa.starter.mapping.DefaultAuthMapper;
import org.apache.syncope.wa.starter.mapping.DefaultTicketExpirationMapper;
import org.apache.syncope.wa.starter.mapping.HttpRequestAccessMapper;
import org.apache.syncope.wa.starter.mapping.OIDCRPClientAppTOMapper;
import org.apache.syncope.wa.starter.mapping.RegisteredServiceMapper;
import org.apache.syncope.wa.starter.mapping.RemoteEndpointAccessMapper;
import org.apache.syncope.wa.starter.mapping.SAML2SPClientAppTOMapper;
import org.apache.syncope.wa.starter.mapping.TicketExpirationMapper;
import org.apache.syncope.wa.starter.mapping.TimeBasedAccessMapper;
import org.apache.syncope.wa.starter.mfa.WAMultifactorAuthenticationTrustStorage;
import org.apache.syncope.wa.starter.oidc.WAOIDCJWKSGeneratorService;
import org.apache.syncope.wa.starter.pac4j.saml.WASAML2ClientCustomizer;
import org.apache.syncope.wa.starter.saml.idp.WASamlIdPCasEventListener;
import org.apache.syncope.wa.starter.saml.idp.metadata.WASamlIdPMetadataGenerator;
import org.apache.syncope.wa.starter.saml.idp.metadata.WASamlIdPMetadataLocator;
import org.apache.syncope.wa.starter.services.WAServiceRegistry;
import org.apache.syncope.wa.starter.surrogate.WASurrogateAuthenticationService;
import org.apache.syncope.wa.starter.webauthn.WAWebAuthnCredentialRepository;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.LdapGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.credential.LdapGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.support.pac4j.authentication.handler.support.DelegatedClientAuthenticationHandler;
import org.apereo.cas.support.saml.idp.SamlIdPCasEventListener;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.ldaptive.ConnectionFactory;
import org.pac4j.core.client.Client;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;

@Configuration(proxyBeanMethods=false)
public class WAContext {
    public static final String CUSTOM_GOOGLE_AUTHENTICATOR_ACCOUNT_REGISTRY = "customGoogleAuthenticatorAccountRegistry";

    private static String version(ConfigurableApplicationContext ctx) {
        return ctx.getEnvironment().getProperty("version");
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenAPI casSwaggerOpenApi(ConfigurableApplicationContext ctx) {
        return new OpenAPI().info(new Info().title("Apache Syncope").description("Apache Syncope " + WAContext.version(ctx)).contact(new Contact().name("The Apache Syncope community").email("dev@syncope.apache.org").url("https://syncope.apache.org")).version(WAContext.version(ctx))).schemaRequirement("BasicAuthentication", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic")).schemaRequirement("Bearer", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT"));
    }

    @ConditionalOnMissingBean
    @Bean
    public AccessMapper defaultAccessMapper() {
        return new DefaultAccessMapper();
    }

    @ConditionalOnMissingBean
    @Bean
    public HttpRequestAccessMapper httpRequestAccessMapper() {
        return new HttpRequestAccessMapper();
    }

    @ConditionalOnMissingBean
    @Bean
    public RemoteEndpointAccessMapper remoteEndpointAccessMapper() {
        return new RemoteEndpointAccessMapper();
    }

    @ConditionalOnMissingBean
    @Bean
    public TimeBasedAccessMapper timeBasedAccessMapper() {
        return new TimeBasedAccessMapper();
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthMapper authMapper() {
        return new DefaultAuthMapper();
    }

    @ConditionalOnMissingBean
    @Bean
    public TicketExpirationMapper ticketExpirationMapper() {
        return new DefaultTicketExpirationMapper();
    }

    @ConditionalOnMissingBean(name={"casSPClientAppTOMapper"})
    @Bean
    public ClientAppMapper casSPClientAppTOMapper() {
        return new CASSPClientAppTOMapper();
    }

    @ConditionalOnMissingBean(name={"oidcRPClientAppTOMapper"})
    @Bean
    public ClientAppMapper oidcRPClientAppTOMapper() {
        return new OIDCRPClientAppTOMapper();
    }

    @ConditionalOnMissingBean(name={"saml2SPClientAppTOMapper"})
    @Bean
    public ClientAppMapper saml2SPClientAppTOMapper() {
        return new SAML2SPClientAppTOMapper();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean
    @Bean
    public RegisteredServiceMapper registeredServiceMapper(CasConfigurationProperties casProperties, ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan, List<MultifactorAuthenticationProvider> multifactorAuthenticationProviders, List<AuthMapper> authMappers, List<AccessMapper> accessMappers, List<AttrReleaseMapper> attrReleaseMappers, List<TicketExpirationMapper> ticketExpirationMappers, List<ClientAppMapper> clientAppMappers) {
        return new RegisteredServiceMapper(Optional.ofNullable(casProperties.getAuthn().getPac4j().getCore().getName()).orElse(DelegatedClientAuthenticationHandler.class.getSimpleName()), authenticationEventExecutionPlan, multifactorAuthenticationProviders, authMappers, accessMappers, attrReleaseMappers, ticketExpirationMappers, clientAppMappers);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean
    @Bean
    public ServiceRegistryExecutionPlanConfigurer syncopeServiceRegistryConfigurer(ConfigurableApplicationContext ctx, WARestClient waRestClient, RegisteredServiceMapper registeredServiceMapper, @Qualifier(value="serviceRegistryListeners") ObjectProvider<List<ServiceRegistryListener>> serviceRegistryListeners) {
        WAServiceRegistry registry = new WAServiceRegistry(waRestClient, registeredServiceMapper, ctx, Optional.ofNullable((List)serviceRegistryListeners.getIfAvailable()).orElseGet(ArrayList::new));
        return plan -> plan.registerServiceRegistry((ServiceRegistry)registry);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Lazy(value=false)
    public SamlIdPCasEventListener samlIdPCasEventListener() {
        return new WASamlIdPCasEventListener();
    }

    @Bean
    public SamlIdPMetadataGenerator samlIdPMetadataGenerator(WARestClient waRestClient, SamlIdPMetadataGeneratorConfigurationContext context) {
        return new WASamlIdPMetadataGenerator(context, waRestClient);
    }

    @Bean
    public SamlIdPMetadataLocator samlIdPMetadataLocator(@Qualifier(value="samlIdPMetadataGeneratorCipherExecutor") CipherExecutor<String, String> cipherExecutor, @Qualifier(value="samlIdPMetadataCache") Cache<String, SamlIdPMetadataDocument> samlIdPMetadataCache, ApplicationContext applicationContext, WARestClient waRestClient) {
        return new WASamlIdPMetadataLocator(cipherExecutor, samlIdPMetadataCache, applicationContext, waRestClient);
    }

    @Bean
    public AuditTrailExecutionPlanConfigurer auditConfigurer(WARestClient waRestClient) {
        return plan -> plan.registerAuditTrailManager((AuditTrailManager)new WAAuditTrailManager(waRestClient));
    }

    @ConditionalOnMissingBean
    @Bean
    public CasEventRepositoryFilter syncopeWAEventRepositoryFilter() {
        return CasEventRepositoryFilter.noOp();
    }

    @Bean
    public CasEventRepository casEventRepository(WARestClient waRestClient, @Qualifier(value="syncopeWAEventRepositoryFilter") CasEventRepositoryFilter syncopeWAEventRepositoryFilter) {
        return new WAEventRepository(syncopeWAEventRepositoryFilter, waRestClient);
    }

    @Bean
    public DelegatedClientFactoryCustomizer<Client> delegatedClientCustomizer(WARestClient waRestClient) {
        return new WASAML2ClientCustomizer(waRestClient);
    }

    @Bean
    public WAGoogleMfaAuthTokenRepository oneTimeTokenAuthenticatorTokenRepository(CasConfigurationProperties casProperties, WARestClient waRestClient) {
        return new WAGoogleMfaAuthTokenRepository(waRestClient, casProperties.getAuthn().getMfa().getGauth().getCore().getTimeStepSize());
    }

    @ConditionalOnMissingBean(name={"customGoogleAuthenticatorAccountRegistry"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry(CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountCipherExecutor") CipherExecutor<String, String> googleAuthenticatorAccountCipherExecutor, @Qualifier(value="googleAuthenticatorScratchCodesCipherExecutor") CipherExecutor<Number, Number> googleAuthenticatorScratchCodesCipherExecutor, IGoogleAuthenticator googleAuthenticatorInstance, WARestClient waRestClient) {
        LdapGoogleAuthenticatorMultifactorProperties ldap = casProperties.getAuthn().getMfa().getGauth().getLdap();
        if (StringUtils.isNotBlank((CharSequence)ldap.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter())) {
            ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
            return new LdapGoogleAuthenticatorTokenCredentialRepository(googleAuthenticatorAccountCipherExecutor, googleAuthenticatorScratchCodesCipherExecutor, googleAuthenticatorInstance, connectionFactory, ldap);
        }
        return new WAGoogleMfaAuthCredentialRepository(waRestClient, googleAuthenticatorInstance);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean(name={"mfaTrustEngine"})
    public MultifactorAuthenticationTrustStorage mfaTrustStorage(CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustRecordKeyGenerator") MultifactorAuthenticationTrustRecordKeyGenerator keyGenerationStrategy, @Qualifier(value="mfaTrustCipherExecutor") CipherExecutor<Serializable, String> mfaTrustCipherExecutor, WARestClient waRestClient) {
        return new WAMultifactorAuthenticationTrustStorage(casProperties.getAuthn().getMfa().getTrusted(), mfaTrustCipherExecutor, keyGenerationStrategy, waRestClient);
    }

    @Bean
    public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService(CasConfigurationProperties casProperties, WARestClient waRestClient) {
        return new WAOIDCJWKSGeneratorService(waRestClient, casProperties.getAuthn().getOidc().getJwks().getCore().getJwksKeyId(), casProperties.getAuthn().getOidc().getJwks().getCore().getJwksType(), casProperties.getAuthn().getOidc().getJwks().getCore().getJwksKeySize());
    }

    @Bean
    public WebAuthnCredentialRepository webAuthnCredentialRepository(CasConfigurationProperties casProperties, WARestClient waRestClient) {
        return new WAWebAuthnCredentialRepository(casProperties, waRestClient);
    }

    @Bean
    public SurrogateAuthenticationService surrogateAuthenticationService(WARestClient waRestClient) {
        return new WASurrogateAuthenticationService(waRestClient);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeCoreHealthIndicator syncopeCoreHealthIndicator(WARestClient waRestClient) {
        return new SyncopeCoreHealthIndicator(waRestClient);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeWAInfoContributor syncopeWAInfoContributor(WAProperties waProperties) {
        return new SyncopeWAInfoContributor(waProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserDetailsService actuatorUserDetailsService(WAProperties waProperties) {
        UserDetails user = User.withUsername((String)waProperties.getAnonymousUser()).password("{noop}" + waProperties.getAnonymousKey()).roles(new String[]{"ANONYMOUS"}).build();
        return new InMemoryUserDetailsManager(new UserDetails[]{user});
    }

    @ConditionalOnProperty(prefix="keymaster", name={"enableAutoRegistration"}, havingValue="true", matchIfMissing=true)
    @Bean
    public KeymasterStart keymasterStart() {
        return new KeymasterStart(NetworkService.Type.WA);
    }

    @ConditionalOnProperty(prefix="keymaster", name={"enableAutoRegistration"}, havingValue="true", matchIfMissing=true)
    @Bean
    public KeymasterStop keymasterStop() {
        return new KeymasterStop(NetworkService.Type.WA);
    }
}

