/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.account;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.impl.account.SimplePasswordlessUserAccountStore;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.jooq.lambda.Unchecked;
import org.springframework.core.io.Resource;

public class JsonPasswordlessUserAccountStore
extends SimplePasswordlessUserAccountStore {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).singleValueAsArray(true).build().toObjectMapper();
    private WatcherService watcherService;
    private final Resource resource;

    public JsonPasswordlessUserAccountStore(Resource resource) {
        super(JsonPasswordlessUserAccountStore.readFromResource(resource));
        this.resource = resource;
        Unchecked.consumer(res -> {
            if (ResourceUtils.isFile((Resource)resource)) {
                this.watcherService = new FileWatcherService(resource.getFile(), file -> this.reload());
                this.watcherService.start(this.getClass().getSimpleName());
            }
        }).accept(resource);
    }

    @Override
    public void reload() {
        this.accounts.clear();
        this.accounts.putAll(JsonPasswordlessUserAccountStore.readFromResource(this.resource));
    }

    private static Map<String, PasswordlessUserAccount> readFromResource(Resource resource) {
        return (Map)FunctionUtils.doUnchecked(() -> (Map)MAPPER.readValue(resource.getInputStream(), (TypeReference)new TypeReference<Map<String, PasswordlessUserAccount>>(){}));
    }
}

