/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.fit.persistence.embedded;

import io.zonky.test.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.util.ReflectionUtils;

public class EmbeddedPostgreSQLContext {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedPostgreSQLContext.class);
    private static final String DEFAULT_POSTGRES_HOST = "localhost";
    private static final int DEFAULT_POSTGRES_PORT = 5432;
    private static final String DEFAULT_POSTGRES_USER = "postgres";
    private static final String DEFAULT_POSTGRES_PASSWORD = "root";
    @Value(value="${embedded.databases:syncope}")
    private String[] embeddedDatabases;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabases(Connection conn) throws SQLException {
        LOG.info("Creating embedded databases: {}", List.of(this.embeddedDatabases));
        try {
            for (String key : this.embeddedDatabases) {
                try (Statement stmt = conn.createStatement();){
                    ResultSet resultSet = stmt.executeQuery("SELECT COUNT(*) FROM pg_database WHERE datname = '" + key + "'");
                    resultSet.next();
                    if (resultSet.getInt(1) <= 0) {
                        stmt.execute("CREATE DATABASE " + key);
                    } else {
                        LOG.info("Database {} exists", (Object)key);
                    }
                    resultSet = stmt.executeQuery("SELECT COUNT(*) FROM pg_user WHERE usename = '" + key + "'");
                    resultSet.next();
                    if (resultSet.getInt(1) <= 0) {
                        stmt.execute("CREATE USER " + key + " WITH PASSWORD '" + key + "'");
                        stmt.execute("ALTER DATABASE " + key + " OWNER TO " + key);
                        continue;
                    }
                    LOG.info("User {} exists", (Object)key);
                }
                catch (SQLException e) {
                    LOG.error("While creating database {}", (Object)key, (Object)e);
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @ConditionalOnClass(name={"org.postgresql.Driver"})
    @Bean(name={"MasterDataSource"})
    public JndiObjectFactoryBean masterDataSource(Environment env) throws SQLException {
        DataSource defaultMasterDS;
        String dbhost = env.getProperty("POSTGRES_HOST", DEFAULT_POSTGRES_HOST);
        int dbport = (Integer)env.getProperty("POSTGRES_PORT", Integer.TYPE, (Object)5432);
        try (Socket s = new Socket(dbhost, dbport);){
            LOG.info("PostgreSQL instance found");
            Class.forName("org.postgresql.Driver");
            Connection conn = DriverManager.getConnection("jdbc:postgresql://" + dbhost + ":" + dbport + "/postgres", env.getProperty("POSTGRES_USER", DEFAULT_POSTGRES_USER), env.getProperty("POSTGRES_PASSWORD", DEFAULT_POSTGRES_PASSWORD));
            this.initDatabases(conn);
            Class<?> clazz = Class.forName("org.postgresql.ds.PGSimpleDataSource");
            defaultMasterDS = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            ReflectionUtils.findMethod(clazz, (String)"setUrl", (Class[])new Class[]{String.class}).invoke((Object)defaultMasterDS, "jdbc:postgresql://" + dbhost + ":" + dbport + "/syncope?stringtype=unspecified");
            ReflectionUtils.findMethod(clazz, (String)"setUser", (Class[])new Class[]{String.class}).invoke((Object)defaultMasterDS, "syncope");
            ReflectionUtils.findMethod(clazz, (String)"setPassword", (Class[])new Class[]{String.class}).invoke((Object)defaultMasterDS, "syncope");
        }
        catch (IOException ioe) {
            LOG.info("Starting embedded PostgreSQL");
            try {
                EmbeddedPostgres pg = EmbeddedPostgres.builder().setPort(dbport).start();
                Connection conn = pg.getPostgresDatabase().getConnection();
                this.initDatabases(conn);
                defaultMasterDS = pg.getDatabase("syncope", "syncope", Map.of("stringtype", "unspecified"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not start embedded PostgreSQL", e);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error while setting up embedded persistence", e);
        }
        JndiObjectFactoryBean masterDataSource = new JndiObjectFactoryBean();
        masterDataSource.setJndiName("java:comp/env/jdbc/syncopeMasterDataSource");
        masterDataSource.setDefaultObject((Object)defaultMasterDS);
        return masterDataSource;
    }
}

