/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.syncope.common.lib.wa.MfaTrustedDevice;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;

public class MfaTrusStorageLogic
extends AbstractAuthProfileLogic {
    public MfaTrusStorageLogic(AuthProfileDataBinder binder, AuthProfileDAO authProfileDAO, EntityFactory entityFactory) {
        super(binder, authProfileDAO, entityFactory);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public Page<MfaTrustedDevice> search(String principal, Long id, OffsetDateTime recordDate, Pageable pageable) {
        List<Comparator> comparatorList = pageable.getSort().stream().map(orderByClause -> {
            Comparator comparator = null;
            if (orderByClause.getProperty().equals("id")) {
                comparator = (o1, o2) -> new CompareToBuilder().append(o1.getId(), o2.getId()).toComparison();
            }
            if (orderByClause.getProperty().equals("expirationDate")) {
                comparator = (o1, o2) -> new CompareToBuilder().append((Object)o1.getExpirationDate(), (Object)o2.getExpirationDate()).toComparison();
            }
            if (orderByClause.getProperty().equals("recordDate")) {
                comparator = (o1, o2) -> new CompareToBuilder().append((Object)o1.getRecordDate(), (Object)o2.getRecordDate()).toComparison();
            }
            if (comparator != null) {
                if (orderByClause.getDirection() == Sort.Direction.DESC) {
                    return comparator.reversed();
                }
                return comparator;
            }
            return null;
        }).filter(Objects::nonNull).toList();
        List<MfaTrustedDevice> devices = (principal == null ? this.authProfileDAO.findAll(Pageable.unpaged()).stream().map(AuthProfile::getMfaTrustedDevices).filter(Objects::nonNull).flatMap(Collection::stream) : this.authProfileDAO.findByOwner(principal).map(AuthProfile::getMfaTrustedDevices).filter(Objects::nonNull).map(Collection::stream).orElse(Stream.empty())).filter(device -> {
            EqualsBuilder builder = new EqualsBuilder();
            builder.appendSuper(device.getExpirationDate().isAfter(ZonedDateTime.now()));
            if (id != null) {
                builder.append((Object)id, (Object)device.getId());
            }
            if (recordDate != null) {
                builder.appendSuper(device.getRecordDate().isAfter(recordDate.toZonedDateTime()));
            }
            return builder.build();
        }).filter(Objects::nonNull).toList();
        List result = devices.stream().limit(pageable.getPageSize()).skip(pageable.getPageSize() * pageable.getPageNumber()).sorted((o1, o2) -> {
            for (Comparator comparator : comparatorList) {
                int compare = comparator.compare(o1, o2);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }).toList();
        return new SyncopePage(result, pageable, (long)devices.size());
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void create(String owner, MfaTrustedDevice device) {
        AuthProfile profile = this.authProfile(owner);
        List devices = profile.getMfaTrustedDevices();
        devices.add(device);
        profile.setMfaTrustedDevices(devices);
        this.authProfileDAO.save((Entity)profile);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(OffsetDateTime expirationDate, String recordKey) {
        this.authProfileDAO.findAll(Pageable.unpaged((Sort)Sort.by((String[])new String[]{"owner"}))).forEach(profile -> {
            List<MfaTrustedDevice> devices = profile.getMfaTrustedDevices();
            if (devices != null) {
                if (recordKey != null) {
                    devices.removeIf(device -> recordKey.equals(device.getRecordKey()));
                } else if (expirationDate != null) {
                    devices.removeIf(device -> device.getExpirationDate().isBefore(expirationDate.toZonedDateTime()));
                } else {
                    devices = List.of();
                }
                profile.setMfaTrustedDevices(devices);
                this.authProfileDAO.save((Entity)profile);
            }
        });
    }
}

