/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.lib.wa.ImpersonationAccount;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ImpersonationLogic
extends AbstractAuthProfileLogic {
    public ImpersonationLogic(AuthProfileDataBinder binder, AuthProfileDAO authProfileDAO, EntityFactory entityFactory) {
        super(binder, authProfileDAO, entityFactory);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<ImpersonationAccount> read(String owner) {
        return this.authProfileDAO.findByOwner(owner).map(AuthProfile::getImpersonationAccounts).orElse(List.of());
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void create(String owner, ImpersonationAccount account) {
        AuthProfile profile = this.authProfile(owner);
        if (profile.getImpersonationAccounts().stream().noneMatch(acct -> acct.getImpersonated().equalsIgnoreCase(account.getImpersonated()))) {
            ArrayList<ImpersonationAccount> accounts = new ArrayList<ImpersonationAccount>(profile.getImpersonationAccounts());
            accounts.add(account);
            profile.setImpersonationAccounts(accounts);
        }
        this.authProfileDAO.save((Entity)profile);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(String owner, String impersonated) {
        this.authProfileDAO.findByOwner(owner).ifPresent(profile -> {
            List accounts = profile.getImpersonationAccounts();
            if (accounts.removeIf(acct -> acct.getImpersonated().equalsIgnoreCase(impersonated))) {
                profile.setImpersonationAccounts(accounts);
                this.authProfileDAO.save((Entity)profile);
            }
        });
    }
}

