/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class GoogleMfaAuthAccountLogic
extends AbstractAuthProfileLogic {
    public GoogleMfaAuthAccountLogic(AuthProfileDataBinder binder, AuthProfileDAO authProfileDAO, EntityFactory entityFactory) {
        super(binder, authProfileDAO, entityFactory);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<GoogleMfaAuthAccount> list() {
        return this.authProfileDAO.findAll(Pageable.unpaged()).stream().map(AuthProfile::getGoogleMfaAuthAccounts).filter(Objects::nonNull).flatMap(Collection::stream).toList();
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(String owner) {
        this.authProfileDAO.findByOwner(owner).ifPresent(profile -> {
            profile.setGoogleMfaAuthAccounts(List.of());
            this.authProfileDAO.save((Entity)profile);
        });
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(long id) {
        this.authProfileDAO.findAll(Pageable.unpaged()).stream().filter(Objects::nonNull).filter(profile -> profile.getGoogleMfaAuthAccounts().stream().allMatch(acct -> acct.getId() == id)).findFirst().ifPresentOrElse(profile -> {
            if (profile.getGoogleMfaAuthAccounts().removeIf(acct -> acct.getId() == id)) {
                this.authProfileDAO.save((Entity)profile);
            }
        }, () -> {
            throw new NotFoundException("Could not find account for id " + id);
        });
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void deleteAll() {
        this.authProfileDAO.findAll(Pageable.unpaged()).forEach(profile -> {
            profile.setGoogleMfaAuthAccounts(List.of());
            this.authProfileDAO.save((Entity)profile);
        });
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void create(String owner, GoogleMfaAuthAccount account) {
        AuthProfile profile = this.authProfile(owner);
        List accounts = profile.getGoogleMfaAuthAccounts();
        accounts.add(account);
        profile.setGoogleMfaAuthAccounts(accounts);
        this.authProfileDAO.save((Entity)profile);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void update(String owner, GoogleMfaAuthAccount account) {
        AuthProfile authProfile = (AuthProfile)this.authProfileDAO.findByOwner(owner).orElseThrow(() -> new NotFoundException("Could not find account for Owner " + owner));
        List accounts = authProfile.getGoogleMfaAuthAccounts();
        if (accounts.removeIf(acct -> acct.getId() == account.getId())) {
            accounts.add(account);
            authProfile.setGoogleMfaAuthAccounts(accounts);
            this.authProfileDAO.save((Entity)authProfile);
        }
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public List<GoogleMfaAuthAccount> read(String owner) {
        return this.authProfileDAO.findByOwner(owner).stream().map(AuthProfile::getGoogleMfaAuthAccounts).filter(Objects::nonNull).filter(accounts -> !accounts.isEmpty()).findFirst().orElseThrow(() -> new NotFoundException("Could not find account for Owner " + owner));
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public GoogleMfaAuthAccount read(long id) {
        return this.authProfileDAO.findAll(Pageable.unpaged()).stream().map(AuthProfile::getGoogleMfaAuthAccounts).filter(Objects::nonNull).map(accounts -> accounts.stream().filter(acct -> acct.getId() == id).findFirst().orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

