/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.SAML2SPEntityTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SAML2SPEntityDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPEntity;
import org.apache.syncope.core.provisioning.api.data.SAML2SPEntityDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class SAML2SPEntityLogic
extends AbstractTransactionalLogic<SAML2SPEntityTO> {
    protected final SAML2SPEntityDataBinder binder;
    protected final SAML2SPEntityDAO saml2SPEntityDAO;

    public SAML2SPEntityLogic(SAML2SPEntityDataBinder binder, SAML2SPEntityDAO saml2SPEntityDAO) {
        this.binder = binder;
        this.saml2SPEntityDAO = saml2SPEntityDAO;
    }

    @PreAuthorize(value="hasRole('SAML2_SP_ENTITY_LIST')")
    @Transactional(readOnly=true)
    public List<SAML2SPEntityTO> list() {
        return this.saml2SPEntityDAO.findAll().stream().map(arg_0 -> ((SAML2SPEntityDataBinder)this.binder).getSAML2SPEntityTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('SAML2_SP_ENTITY_GET') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public SAML2SPEntityTO read(String key) {
        return this.saml2SPEntityDAO.findById(key).map(arg_0 -> ((SAML2SPEntityDataBinder)this.binder).getSAML2SPEntityTO(arg_0)).orElseThrow(() -> new NotFoundException(key + " not found"));
    }

    @PreAuthorize(value="hasRole('SAML2_SP_ENTITY_SET') or hasRole('ANONYMOUS')")
    public SAML2SPEntityTO set(SAML2SPEntityTO entityTO) {
        SAML2SPEntity entity = this.saml2SPEntityDAO.findById(entityTO.getKey()).map(metadata -> this.binder.update(metadata, entityTO)).orElseGet(() -> this.binder.create(entityTO));
        return this.binder.getSAML2SPEntityTO((SAML2SPEntity)this.saml2SPEntityDAO.save((Entity)entity));
    }

    @PreAuthorize(value="hasRole('SAML2_SP_ENTITY_DELETE')")
    public void delete(String key) {
        this.saml2SPEntityDAO.findById(key).ifPresentOrElse(arg_0 -> ((SAML2SPEntityDAO)this.saml2SPEntityDAO).delete(arg_0), () -> new NotFoundException("SAML SP " + key));
    }

    protected SAML2SPEntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof SAML2SPEntityTO)) continue;
                SAML2SPEntityTO saml2SPEntityTO = (SAML2SPEntityTO)object;
                key = saml2SPEntityTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getSAML2SPEntityTO((SAML2SPEntity)this.saml2SPEntityDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

