/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.am.AuthModule;
import org.apache.syncope.core.provisioning.api.data.AuthModuleDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class AuthModuleLogic
extends AbstractTransactionalLogic<AuthModuleTO> {
    protected final AuthModuleDataBinder binder;
    protected final AuthModuleDAO authModuleDAO;

    public AuthModuleLogic(AuthModuleDataBinder binder, AuthModuleDAO authModuleDAO) {
        this.binder = binder;
        this.authModuleDAO = authModuleDAO;
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_CREATE')")
    public AuthModuleTO create(AuthModuleTO authModuleTO) {
        return this.binder.getAuthModuleTO((AuthModule)this.authModuleDAO.save((Entity)this.binder.create(authModuleTO)));
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_UPDATE')")
    public AuthModuleTO update(AuthModuleTO authModuleTO) {
        AuthModule authModule = (AuthModule)this.authModuleDAO.findById(authModuleTO.getKey()).orElseThrow(() -> new NotFoundException("AuthModule " + authModuleTO.getKey()));
        return this.binder.getAuthModuleTO((AuthModule)this.authModuleDAO.save((Entity)this.binder.update(authModule, authModuleTO)));
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_LIST') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<AuthModuleTO> list() {
        return this.authModuleDAO.findAll().stream().map(arg_0 -> ((AuthModuleDataBinder)this.binder).getAuthModuleTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_READ')")
    @Transactional(readOnly=true)
    public AuthModuleTO read(String key) {
        AuthModule authModule = (AuthModule)this.authModuleDAO.findById(key).orElseThrow(() -> new NotFoundException("AuthModule " + key));
        return this.binder.getAuthModuleTO(authModule);
    }

    @PreAuthorize(value="hasRole('AUTH_MODULE_DELETE')")
    public AuthModuleTO delete(String key) {
        AuthModule authModule = (AuthModule)this.authModuleDAO.findById(key).orElseThrow(() -> new NotFoundException("AuthModule " + key));
        AuthModuleTO deleted = this.binder.getAuthModuleTO(authModule);
        this.authModuleDAO.delete((Entity)authModule);
        return deleted;
    }

    protected AuthModuleTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key;
        if (ArrayUtils.isEmpty((Object[])args)) {
            throw new UnresolvedReferenceException();
        }
        Object object = args[0];
        if (object instanceof String) {
            String string;
            key = string = (String)object;
        } else {
            object = args[0];
            if (object instanceof AuthModuleTO) {
                AuthModuleTO authModuleTO = (AuthModuleTO)object;
                key = authModuleTO.getKey();
            } else {
                throw new UnresolvedReferenceException();
            }
        }
        try {
            return this.binder.getAuthModuleTO((AuthModule)this.authModuleDAO.findById(key).orElseThrow());
        }
        catch (Throwable ignore) {
            LOG.debug("Unresolved reference", ignore);
            throw new UnresolvedReferenceException(ignore);
        }
    }
}

