/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.syncope.common.rest.api.beans.CSVPushSpec;
import org.apache.syncope.common.rest.api.beans.ReconQuery;
import org.apache.syncope.common.rest.api.service.ReconciliationService;
import org.apache.syncope.core.logic.ReconciliationLogic;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.search.FilterVisitor;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.rest.cxf.service.AbstractSearchService;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationServiceImpl
extends AbstractSearchService
implements ReconciliationService {
    protected final ReconciliationLogic logic;

    public ReconciliationServiceImpl(SearchCondVisitor searchCondVisitor, ReconciliationLogic logic) {
        super(searchCondVisitor);
        this.logic = logic;
    }

    private void validate(ReconQuery reconQuery) {
        if (reconQuery.getAnyKey() == null && reconQuery.getFiql() == null || reconQuery.getAnyKey() != null && reconQuery.getFiql() != null) {
            throw new ValidationException("Either provide anyKey or fiql, not both");
        }
    }

    private Pair<Filter, Set<String>> buildFromFIQL(ReconQuery reconQuery) {
        Filter filter = null;
        HashSet moreAttrsToGet = new HashSet();
        if (reconQuery.getMoreAttrsToGet() != null) {
            moreAttrsToGet.addAll(reconQuery.getMoreAttrsToGet());
        }
        if (StringUtils.isNotBlank((CharSequence)reconQuery.getFiql())) {
            try {
                FilterVisitor visitor = new FilterVisitor();
                SearchCondition sc = this.searchContext.getCondition(reconQuery.getFiql(), SearchBean.class);
                sc.accept((SearchConditionVisitor)visitor);
                filter = visitor.getQuery();
                moreAttrsToGet.addAll(visitor.getAttrs());
            }
            catch (Exception e) {
                LOG.error("Invalid FIQL expression: {}", (Object)reconQuery.getFiql(), (Object)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
                sce.getElements().add(reconQuery.getFiql());
                sce.getElements().add(ExceptionUtils.getRootCauseMessage((Throwable)e));
                throw sce;
            }
        }
        return Pair.of(filter, moreAttrsToGet);
    }

    public ReconStatus status(ReconQuery query) {
        this.validate(query);
        if (query.getAnyKey() != null) {
            return this.logic.status(query.getAnyTypeKey(), query.getResourceKey(), query.getAnyKey(), Optional.ofNullable(query.getMoreAttrsToGet()).orElse(Set.of()));
        }
        Pair<Filter, Set<String>> fromFIQL = this.buildFromFIQL(query);
        return this.logic.status(query.getAnyTypeKey(), query.getResourceKey(), (Filter)fromFIQL.getLeft(), (Set)fromFIQL.getRight());
    }

    public List<ProvisioningReport> push(ReconQuery query, PushTaskTO pushTask) {
        this.validate(query);
        if (query.getAnyKey() != null) {
            return this.logic.push(query.getAnyTypeKey(), query.getResourceKey(), query.getAnyKey(), pushTask);
        }
        Pair<Filter, Set<String>> fromFIQL = this.buildFromFIQL(query);
        return this.logic.push(query.getAnyTypeKey(), query.getResourceKey(), (Filter)fromFIQL.getLeft(), (Set)fromFIQL.getRight(), pushTask);
    }

    public List<ProvisioningReport> pull(ReconQuery query, PullTaskTO pullTask) {
        this.validate(query);
        if (query.getAnyKey() != null) {
            return this.logic.pull(query.getAnyTypeKey(), query.getResourceKey(), query.getAnyKey(), Optional.ofNullable(query.getMoreAttrsToGet()).orElse(Set.of()), pullTask);
        }
        Pair<Filter, Set<String>> fromFIQL = this.buildFromFIQL(query);
        return this.logic.pull(query.getAnyTypeKey(), query.getResourceKey(), (Filter)fromFIQL.getLeft(), (Set)fromFIQL.getRight(), pullTask);
    }

    public Response push(AnyQuery query, CSVPushSpec spec) {
        String realm = StringUtils.prependIfMissing((String)query.getRealm(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        SearchCond searchCond = StringUtils.isBlank((CharSequence)query.getFiql()) ? null : this.getSearchCond(query.getFiql(), realm);
        StreamingOutput sout = os -> this.logic.push(searchCond, ReconciliationServiceImpl.pageable((AbstractQuery)query), realm, spec, os);
        return Response.ok((Object)sout).type("text/csv").header("Content-Disposition", (Object)("attachment; filename=" + AuthContextUtils.getDomain() + ".csv")).build();
    }

    public List<ProvisioningReport> pull(CSVPullSpec spec, InputStream csv) {
        return this.logic.pull(spec, csv);
    }
}

