/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service.wa;

import java.time.LocalDateTime;
import java.util.List;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthToken;
import org.apache.syncope.common.rest.api.service.wa.GoogleMfaAuthTokenService;
import org.apache.syncope.core.logic.wa.GoogleMfaAuthTokenLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.stereotype.Service;

@Service
public class GoogleMfaAuthTokenServiceImpl
extends AbstractService
implements GoogleMfaAuthTokenService {
    protected final GoogleMfaAuthTokenLogic logic;

    public GoogleMfaAuthTokenServiceImpl(GoogleMfaAuthTokenLogic logic) {
        this.logic = logic;
    }

    public void delete(LocalDateTime expirationDate) {
        if (expirationDate == null) {
            this.logic.deleteAll();
        } else {
            this.logic.delete(expirationDate);
        }
    }

    public void delete(String owner, int otp) {
        this.logic.delete(owner, otp);
    }

    public void delete(String owner) {
        this.logic.delete(owner);
    }

    public void delete(int otp) {
        this.logic.delete(otp);
    }

    public void store(String owner, GoogleMfaAuthToken token) {
        this.logic.store(owner, token);
    }

    public GoogleMfaAuthToken read(String owner, int otp) {
        return this.logic.read(owner, otp);
    }

    private PagedResult<GoogleMfaAuthToken> build(List<GoogleMfaAuthToken> read) {
        PagedResult result = new PagedResult();
        result.setPage(1);
        result.setSize(read.size());
        result.setTotalCount((long)read.size());
        result.getResult().addAll(read);
        return result;
    }

    public PagedResult<GoogleMfaAuthToken> read(String owner) {
        return this.build(this.logic.read(owner));
    }

    public PagedResult<GoogleMfaAuthToken> list() {
        return this.build(this.logic.list());
    }
}

