/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.syncope.common.rest.api.service.SRARouteService;
import org.apache.syncope.core.logic.SRARouteLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.stereotype.Service;

@Service
public class SRARouteServiceImpl
extends AbstractService
implements SRARouteService {
    protected final SRARouteLogic logic;

    public SRARouteServiceImpl(SRARouteLogic logic) {
        this.logic = logic;
    }

    public List<SRARouteTO> list() {
        return this.logic.list();
    }

    public Response create(SRARouteTO routeTO) {
        SRARouteTO createdRoute = this.logic.create(routeTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(createdRoute.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)createdRoute.getKey()).build();
    }

    public SRARouteTO read(String key) {
        return this.logic.read(key);
    }

    public void update(SRARouteTO routeTO) {
        this.logic.update(routeTO);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }

    public void pushToSRA() {
        this.logic.pushToSRA();
    }
}

