/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.util.Saml20HexRandomIdGenerator;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

public class SamlIdPInitiatedProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPInitiatedProfileHandlerController.class);
    private static final List<String> PARAMETERS_TO_IGNORE = List.of("target", "time", "SigAlg", "Signature", "shire", "providerId", "RelayState", "SAMLRequest", "SAMLResponse");

    public SamlIdPInitiatedProfileHandlerController(SamlProfileHandlerConfigurationContext ctx) {
        super(ctx);
    }

    @GetMapping(path={"/idp/profile/SAML2/Unsolicited/SSO"})
    protected ModelAndView handleIdPInitiatedSsoRequest(HttpServletResponse response, HttpServletRequest request) throws Throwable {
        String providerId = this.extractProviderId(request);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(providerId, request);
        Optional<SamlRegisteredServiceMetadataAdaptor> adaptor = this.getSamlMetadataFacadeFor(registeredService, providerId);
        if (adaptor.isEmpty()) {
            throw UnauthorizedServiceException.denied((String)"Cannot find metadata linked to %s".formatted(providerId));
        }
        SamlRegisteredServiceMetadataAdaptor facade = adaptor.get();
        String shire = this.extractShire(request, providerId, facade);
        String target = request.getParameter("target");
        String time = request.getParameter("time");
        AuthnRequest authnRequest = this.buildAuthnRequest(providerId, shire, time);
        if (StringUtils.isNotBlank((CharSequence)target)) {
            request.setAttribute("RelayState", (Object)target);
        }
        MessageContext ctx = new MessageContext();
        if (facade.isAuthnRequestsSigned() || registeredService.isSignUnsolicitedAuthnRequest()) {
            this.getConfigurationContext().getSamlObjectSigner().encode(authnRequest, registeredService, facade, response, request, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (RequestAbstractType)authnRequest, ctx);
        }
        ctx.setMessage((Object)authnRequest);
        SAMLBindingContext bindingContext = (SAMLBindingContext)ctx.ensureSubcontext(SAMLBindingContext.class);
        Objects.requireNonNull(bindingContext).setHasBindingSignature(false);
        SAMLBindingSupport.setRelayState((MessageContext)ctx, (String)target);
        Pair pair = Pair.of((Object)authnRequest, (Object)ctx);
        ModelAndView modelAndView = this.initiateAuthenticationRequest((Pair<? extends RequestAbstractType, MessageContext>)pair, response, request);
        if (modelAndView != null) {
            RedirectView view = (RedirectView)modelAndView.getView();
            URIBuilder urlBuilder = new URIBuilder(Objects.requireNonNull(view).getUrl());
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String parameterName = (String)paramNames.nextElement();
                if (!SamlIdPInitiatedProfileHandlerController.canAcceptParameter(parameterName)) continue;
                urlBuilder.addParameter(parameterName, request.getParameter(parameterName));
            }
            view.setUrl(urlBuilder.build().toString());
        }
        return modelAndView;
    }

    private static boolean canAcceptParameter(String parameterName) {
        return !PARAMETERS_TO_IGNORE.contains(parameterName);
    }

    protected AuthnRequest buildAuthnRequest(String providerId, String shire, String time) {
        AuthnRequest authnRequest = this.buildSamlObject(AuthnRequest.DEFAULT_ELEMENT_NAME, AuthnRequest.class);
        authnRequest.setAssertionConsumerServiceURL(shire);
        Issuer issuer = this.buildSamlObject(Issuer.DEFAULT_ELEMENT_NAME, Issuer.class);
        issuer.setValue(providerId);
        authnRequest.setIssuer(issuer);
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        NameIDPolicy nameIDPolicy = this.buildSamlObject(NameIDPolicy.DEFAULT_ELEMENT_NAME, NameIDPolicy.class);
        nameIDPolicy.setAllowCreate(Boolean.TRUE);
        authnRequest.setNameIDPolicy(nameIDPolicy);
        if (NumberUtils.isCreatable((String)time)) {
            authnRequest.setIssueInstant(Instant.ofEpochMilli(Long.parseLong(time)));
        } else {
            authnRequest.setIssueInstant(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
        }
        authnRequest.setID(Saml20HexRandomIdGenerator.INSTANCE.getNewString());
        authnRequest.setForceAuthn(Boolean.FALSE);
        Extensions extensions = this.buildSamlObject(Extensions.DEFAULT_ELEMENT_NAME, Extensions.class);
        RequesterID requesterId = this.buildSamlObject(RequesterID.DEFAULT_ELEMENT_NAME, RequesterID.class);
        requesterId.setURI(this.getConfigurationContext().getCasProperties().getAuthn().getSamlIdp().getCore().getEntityId());
        extensions.getUnknownXMLObjects().add(requesterId);
        authnRequest.setExtensions(extensions);
        return authnRequest;
    }

    protected <T> T buildSamlObject(QName qname, Class<T> clazz) {
        XMLObjectBuilderFactory builderFactory = this.getConfigurationContext().getOpenSamlConfigBean().getBuilderFactory();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)builderFactory.getBuilder(qname);
        return clazz.cast(Objects.requireNonNull(builder).buildObject());
    }

    protected String extractShire(HttpServletRequest request, String providerId, SamlRegisteredServiceMetadataAdaptor facade) throws MessageDecodingException {
        String shire = request.getParameter("shire");
        if (StringUtils.isBlank((CharSequence)shire)) {
            LOGGER.info("Resolving service provider assertion consumer service URL for [{}] and binding [{}]", (Object)providerId, (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            AssertionConsumerService acs = facade.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            shire = Optional.ofNullable(acs).map(assertionConsumerService -> StringUtils.isBlank((CharSequence)assertionConsumerService.getResponseLocation()) ? assertionConsumerService.getLocation() : assertionConsumerService.getResponseLocation()).orElse(null);
        }
        if (StringUtils.isBlank((CharSequence)shire)) {
            LOGGER.warn("Unable to resolve service provider assertion consumer service URL for AuthnRequest construction for entityID: [{}]", (Object)providerId);
            throw new MessageDecodingException("Unable to resolve SP ACS URL for AuthnRequest construction");
        }
        return shire;
    }

    protected String extractProviderId(HttpServletRequest request) throws MessageDecodingException {
        String providerId = request.getParameter("providerId");
        if (StringUtils.isBlank((CharSequence)providerId)) {
            LOGGER.warn("No providerId parameter given in unsolicited SSO authentication request.");
            throw new MessageDecodingException("Missing providerId");
        }
        return providerId;
    }
}

