/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.extractors;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import org.pac4j.scribe.model.WechatToken;

public class WechatJsonExtractor
extends OAuth2AccessTokenJsonExtractor {
    protected WechatJsonExtractor() {
    }

    public static WechatJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    protected OAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, JsonNode response, String rawResponse) {
        String openid = WechatJsonExtractor.extractRequiredParameter((JsonNode)response, (String)"openid", (String)rawResponse).asText();
        String unionid = WechatJsonExtractor.extractRequiredParameter((JsonNode)response, (String)"unionid", (String)rawResponse).asText();
        WechatToken token = new WechatToken(accessToken, tokenType, expiresIn, refreshToken, scope, rawResponse, openid, unionid);
        return token;
    }

    private static class InstanceHolder {
        private static final WechatJsonExtractor INSTANCE = new WechatJsonExtractor();

        private InstanceHolder() {
        }
    }
}

