/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.executor.CasFlowExecutor;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.context.TransientSecurityContext;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.executor.FlowExecutor;

public class CasWebflowSecurityContextRepository
implements SecurityContextRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebflowSecurityContextRepository.class);
    private final SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private final ConfigurableApplicationContext applicationContext;

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        HttpServletRequest request = requestResponseHolder.getRequest();
        if (this.containsContext(request)) {
            org.apereo.cas.authentication.Authentication authentication = Objects.requireNonNull(this.getInProgressAuthentication(request));
            Principal principal = authentication.getPrincipal();
            List authorities = principal.getAttributes().keySet().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
            authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
            PreAuthenticatedAuthenticationToken springSecurityAuthentication = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)authentication.getCredentials(), authorities);
            springSecurityAuthentication.setAuthenticated(true);
            springSecurityAuthentication.setDetails((Object)new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(request, authorities));
            return new TransientSecurityContext((Authentication)springSecurityAuthentication);
        }
        return this.securityContextHolderStrategy.createEmptyContext();
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
    }

    public boolean containsContext(HttpServletRequest request) {
        return this.getInProgressAuthentication(request) != null;
    }

    private org.apereo.cas.authentication.Authentication getInProgressAuthentication(HttpServletRequest request) {
        Set flowExecutors = this.applicationContext.getBeansOfType(FlowExecutor.class).values().stream().filter(CasFlowExecutor.class::isInstance).map(CasFlowExecutor.class::cast).collect(Collectors.toSet());
        for (CasFlowExecutor casFlowExecutor : flowExecutors) {
            FlowExecutionRepository flowExecutionRepository = casFlowExecutor.getFlowExecutionRepository();
            String execution = casFlowExecutor.getFlowUrlHandler().getFlowExecutionKey(request);
            if (!StringUtils.isNotBlank((CharSequence)execution)) continue;
            try {
                FlowExecutionKey flowExecutionKey = flowExecutionRepository.parseFlowExecutionKey(execution);
                FlowExecution flowExecution = flowExecutionRepository.getFlowExecution(flowExecutionKey);
                return WebUtils.getAuthentication((MutableAttributeMap)flowExecution.getConversationScope());
            }
            catch (Exception e) {
                LOGGER.debug("Unable to determine authentication attempt from the webflow context: [{}]", (Object)e.getMessage());
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Generated
    public CasWebflowSecurityContextRepository(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

