/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.ActuatorEndpointProperties;
import org.apereo.cas.configuration.model.core.monitor.JaasSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.security.authentication.IpAddressAuthorizationManager;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.jaas.JaasAuthenticationProvider;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.www.BasicAuthenticationConverter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Order(value=1000)
public class CasWebSecurityConfigurerAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebSecurityConfigurerAdapter.class);
    private final ObjectPostProcessor<BasicAuthenticationFilter> basicAuthFilterPostProcessor = new ObjectPostProcessor<BasicAuthenticationFilter>(){

        public <O extends BasicAuthenticationFilter> O postProcess(O object) {
            final Set patternsToIgnore = CasWebSecurityConfigurerAdapter.this.getAllowedPatternsToIgnore().stream().map(AntPathRequestMatcher::new).collect(Collectors.toSet());
            object.setAuthenticationConverter((AuthenticationConverter)new BasicAuthenticationConverter(this){

                public UsernamePasswordAuthenticationToken convert(HttpServletRequest request) {
                    boolean requestIsNotIgnored = patternsToIgnore.stream().noneMatch(requestMatcher -> requestMatcher.matches(request));
                    return requestIsNotIgnored ? super.convert(request) : null;
                }
            });
            return object;
        }
    };
    private final CasConfigurationProperties casProperties;
    private final WebEndpointProperties webEndpointProperties;
    private final ObjectProvider<PathMappedEndpoints> pathMappedEndpoints;
    private final List<CasWebSecurityConfigurer> webSecurityConfigurers;
    private final SecurityContextRepository securityContextRepository;

    private static List<String> prepareProtocolEndpoint(String endpoint) {
        String baseEndpoint = StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return List.of(baseEndpoint.concat("**"), StringUtils.appendIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("**"));
    }

    private static void configureJaasAuthenticationProvider(HttpSecurity http, JaasSecurityActuatorEndpointsMonitorProperties jaas) throws Exception {
        JaasAuthenticationProvider provider = new JaasAuthenticationProvider();
        provider.setLoginConfig(jaas.getLoginConfig());
        provider.setLoginContextName(jaas.getLoginContextName());
        provider.setRefreshConfigurationOnStartup(jaas.isRefreshConfigurationOnStartup());
        provider.afterPropertiesSet();
        http.authenticationProvider((AuthenticationProvider)provider);
    }

    public void configureWebSecurity(WebSecurity web) {
    }

    public HttpSecurity configureHttpSecurity(HttpSecurity http) throws Exception {
        http.cors(Customizer.withDefaults()).csrf(AbstractHttpConfigurer::disable).headers(AbstractHttpConfigurer::disable).logout(AbstractHttpConfigurer::disable).requiresChannel(customizer -> ((ChannelSecurityConfigurer.RequiresChannelUrl)customizer.requestMatchers(new RequestMatcher[]{r -> r.getHeader("X-Forwarded-Proto") != null})).requiresSecure());
        List<String> patterns = this.getAllowedPatternsToIgnore();
        LOGGER.debug("Configuring protocol endpoints [{}] to exclude/ignore from http security", patterns);
        HttpSecurity requests = http.authorizeHttpRequests(customizer -> {
            RequestMatcher[] matchers = patterns.stream().map(AntPathRequestMatcher::new).toList().toArray(new RequestMatcher[0]);
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(matchers)).permitAll();
        });
        this.webSecurityConfigurers.stream().filter(BeanSupplier::isNotProxy).forEach(Unchecked.consumer(cfg -> cfg.configure((Object)http)));
        Map endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint();
        endpoints.forEach(Unchecked.biConsumer((key, endpointProps) -> {
            EndpointRequest.EndpointRequestMatcher endpoint = EndpointRequest.to((String[])new String[]{key});
            endpointProps.getAccess().forEach(Unchecked.consumer(access -> this.configureEndpointAccess(requests, (ActuatorEndpointProperties.EndpointAccessLevel)access, (ActuatorEndpointProperties)endpointProps, endpoint)));
        }));
        this.configureEndpointAccessToDenyUndefined(requests);
        this.configureEndpointAccessForStaticResources(requests);
        this.configureEndpointAccessByFormLogin(requests);
        JaasSecurityActuatorEndpointsMonitorProperties jaas = this.casProperties.getMonitor().getEndpoints().getJaas();
        FunctionUtils.doIfNotNull((Object)jaas.getLoginConfig(), __ -> CasWebSecurityConfigurerAdapter.configureJaasAuthenticationProvider(http, jaas));
        http.securityContext(securityContext -> securityContext.securityContextRepository(this.securityContextRepository));
        this.webSecurityConfigurers.stream().filter(BeanSupplier::isNotProxy).forEach(Unchecked.consumer(cfg -> cfg.finish((Object)http)));
        return http;
    }

    protected List<String> getAllowedPatternsToIgnore() {
        List<String> patterns = this.webSecurityConfigurers.stream().filter(BeanSupplier::isNotProxy).map(CasWebSecurityConfigurer::getIgnoredEndpoints).flatMap(Collection::stream).map(CasWebSecurityConfigurerAdapter::prepareProtocolEndpoint).flatMap(Collection::stream).collect(Collectors.toList());
        patterns.add("/webjars/**");
        patterns.add("/themes/**");
        patterns.add("/js/**");
        patterns.add("/css/**");
        patterns.add("/images/**");
        patterns.add("/static/**");
        patterns.add("/error");
        patterns.add("/favicon.ico");
        patterns.add("/adminlogin");
        patterns.add("/");
        patterns.add(this.webEndpointProperties.getBasePath());
        patterns.addAll(this.casProperties.getMonitor().getEndpoints().getIgnoredEndpoints());
        return patterns;
    }

    protected void configureEndpointAccessToDenyUndefined(HttpSecurity http) {
        Set endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint().keySet();
        ActuatorEndpointProperties endpointDefaults = this.casProperties.getMonitor().getEndpoints().getDefaultEndpointProperties();
        ((PathMappedEndpoints)this.pathMappedEndpoints.getObject()).stream().filter(BeanSupplier::isNotProxy).forEach(endpoint -> {
            String rootPath = endpoint.getRootPath();
            if (endpoints.contains(rootPath)) {
                LOGGER.trace("Endpoint security is defined for endpoint [{}]", (Object)rootPath);
            } else {
                List defaultAccessRules = endpointDefaults.getAccess();
                LOGGER.trace("Endpoint security is NOT defined for endpoint [{}]. Using default security rules [{}]", (Object)rootPath, (Object)endpointDefaults);
                EndpointRequest.EndpointRequestMatcher endpointRequest = EndpointRequest.to((String[])new String[]{rootPath}).excludingLinks();
                defaultAccessRules.forEach(Unchecked.consumer(access -> this.configureEndpointAccess(http, (ActuatorEndpointProperties.EndpointAccessLevel)access, endpointDefaults, endpointRequest)));
            }
        });
    }

    protected void configureEndpointAccessForStaticResources(HttpSecurity requests) throws Exception {
        requests.authorizeHttpRequests(customizer -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/resources/**")})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/static/**")})).permitAll();
        });
    }

    protected void configureEndpointAccessByFormLogin(HttpSecurity http) throws Exception {
        if (this.casProperties.getMonitor().getEndpoints().isFormLoginEnabled()) {
            http.formLogin(customize -> customize.loginPage("/adminlogin"));
        } else {
            http.formLogin(AbstractHttpConfigurer::disable);
        }
    }

    protected void configureEndpointAccess(HttpSecurity httpSecurity, ActuatorEndpointProperties.EndpointAccessLevel access, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        switch (access) {
            case AUTHORITY: {
                this.configureEndpointAccessByAuthority(httpSecurity, properties, endpoint);
                break;
            }
            case ROLE: {
                this.configureEndpointAccessByRole(httpSecurity, properties, endpoint);
                break;
            }
            case AUTHENTICATED: {
                this.configureEndpointAccessAuthenticated(httpSecurity, endpoint);
                break;
            }
            case IP_ADDRESS: {
                this.configureEndpointAccessByIpAddress(httpSecurity, properties, endpoint);
                break;
            }
            case PERMIT: {
                this.configureEndpointAccessPermitAll(httpSecurity, endpoint);
                break;
            }
            case ANONYMOUS: {
                this.configureEndpointAccessAnonymously(httpSecurity, endpoint);
                break;
            }
            default: {
                this.configureEndpointAccessToDenyAll(httpSecurity, endpoint);
            }
        }
    }

    protected void configureEndpointAccessPermitAll(HttpSecurity requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        requests.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).permitAll());
    }

    protected void configureEndpointAccessToDenyAll(HttpSecurity requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        requests.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).denyAll());
    }

    protected void configureEndpointAccessAnonymously(HttpSecurity requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        requests.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).permitAll());
    }

    protected void configureEndpointAccessByIpAddress(HttpSecurity requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        requests.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).access((AuthorizationManager)new IpAddressAuthorizationManager(this.casProperties, properties)));
    }

    protected void configureEndpointAccessAuthenticated(HttpSecurity http, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        http.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).authenticated()).httpBasic(customizer -> customizer.withObjectPostProcessor(this.basicAuthFilterPostProcessor));
    }

    protected void configureEndpointAccessByRole(HttpSecurity http, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        http.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyRole(properties.getRequiredRoles().toArray(ArrayUtils.EMPTY_STRING_ARRAY))).httpBasic(customizer -> customizer.withObjectPostProcessor(this.basicAuthFilterPostProcessor));
    }

    protected void configureEndpointAccessByAuthority(HttpSecurity http, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        http.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyAuthority(properties.getRequiredAuthorities().toArray(ArrayUtils.EMPTY_STRING_ARRAY))).httpBasic(customizer -> customizer.withObjectPostProcessor(this.basicAuthFilterPostProcessor));
    }

    @Generated
    public CasWebSecurityConfigurerAdapter(CasConfigurationProperties casProperties, WebEndpointProperties webEndpointProperties, ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<CasWebSecurityConfigurer> webSecurityConfigurers, SecurityContextRepository securityContextRepository) {
        this.casProperties = casProperties;
        this.webEndpointProperties = webEndpointProperties;
        this.pathMappedEndpoints = pathMappedEndpoints;
        this.webSecurityConfigurers = webSecurityConfigurers;
        this.securityContextRepository = securityContextRepository;
    }
}

