/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web.flow;

import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.bucket4j.consumer.BucketConsumer;
import org.apereo.cas.bucket4j.consumer.BucketConsumptionResult;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorAuthenticationProvider;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCommunicationStrategy;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorMakePhoneCall;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorSendEmail;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorSendSms;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CasSimpleMultifactorSendTokenAction
extends AbstractMultifactorAuthenticationAction<CasSimpleMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleMultifactorSendTokenAction.class);
    public static final String FLOW_SCOPE_ATTR_EMAIL_RECIPIENTS = "emailRecipients";
    public static final String FLOW_SCOPE_ATTR_SMS_RECIPIENTS = "smsRecipients";
    private static final String MESSAGE_MFA_TOKEN_SENT = "cas.mfa.simple.label.tokensent";
    private static final String MESSAGE_MFA_CONTACT_FAILED_SMS = "cas.mfa.simple.label.contactfailed.sms";
    private static final String MESSAGE_MFA_CONTACT_FAILED_EMAIL = "cas.mfa.simple.label.contactfailed.email";
    protected final CommunicationsManager communicationsManager;
    protected final CasSimpleMultifactorAuthenticationService multifactorAuthenticationService;
    protected final CasSimpleMultifactorAuthenticationProperties properties;
    protected final CasSimpleMultifactorTokenCommunicationStrategy tokenCommunicationStrategy;
    protected final BucketConsumer bucketConsumer;

    protected boolean isNotificationSent(Principal principal, Ticket token) {
        return this.communicationsManager.isNotificationSenderDefined() && this.communicationsManager.notify(principal, "Apereo CAS Token", String.format("Token: %s", token.getId()));
    }

    protected Event doPreExecute(RequestContext requestContext) throws Exception {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        BucketConsumptionResult result = this.bucketConsumer.consume(this.getThrottledRequestKeyFor(authentication, requestContext));
        result.getHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
        return result.isConsumed() ? super.doPreExecute(requestContext) : this.error();
    }

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        boolean phoneCallSent;
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
        CasSimpleMultifactorAuthenticationTicket token = this.getOrCreateToken(requestContext, principal);
        LOGGER.debug("Using token [{}] created at [{}]", (Object)token.getId(), (Object)token.getCreationTime());
        LinkedHashMap<CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions, List<String>> mapOfAllRecipients = new LinkedHashMap<CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions, List<String>>();
        EnumSet<CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions> communicationStrategy = this.tokenCommunicationStrategy.determineStrategy(token);
        boolean smsSent = false;
        if (communicationStrategy.contains((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.SMS)) {
            CasSimpleMultifactorSendSms cmd = CasSimpleMultifactorSendSms.of(this.communicationsManager, this.properties);
            List<String> recipients = cmd.getSmsRecipients(principal);
            mapOfAllRecipients.put(CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.SMS, recipients);
            if (recipients.size() > 1) {
                List<String> selectedSmsRecipients = this.findSelectedSmsRecipients(requestContext, principal);
                LOGGER.debug("Selected SMS recipients are [{}]", selectedSmsRecipients);
                if (!selectedSmsRecipients.isEmpty() && !(smsSent = cmd.send(principal, (Ticket)token, requestContext, selectedSmsRecipients))) {
                    WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)MESSAGE_MFA_CONTACT_FAILED_SMS);
                }
            } else {
                smsSent = cmd.send(principal, (Ticket)token, requestContext);
                if (!smsSent) {
                    WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)MESSAGE_MFA_CONTACT_FAILED_SMS);
                }
            }
        }
        boolean emailSent = false;
        if (communicationStrategy.contains((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.EMAIL)) {
            CasSimpleMultifactorSendEmail cmd = CasSimpleMultifactorSendEmail.of(this.communicationsManager, this.properties);
            List<String> recipients = cmd.getEmailMessageRecipients(principal);
            mapOfAllRecipients.put(CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.EMAIL, recipients);
            if (recipients.size() > 1) {
                List<String> selectedEmailRecipients = this.findSelectedEmailRecipients(requestContext, principal);
                LOGGER.debug("Selected email recipients are [{}]", selectedEmailRecipients);
                if (!selectedEmailRecipients.isEmpty() && !(emailSent = cmd.send(principal, (Ticket)token, selectedEmailRecipients, requestContext).isAnyEmailSent())) {
                    WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)MESSAGE_MFA_CONTACT_FAILED_EMAIL);
                }
            } else {
                emailSent = cmd.send(principal, (Ticket)token, requestContext).isAnyEmailSent();
                if (!emailSent) {
                    WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)MESSAGE_MFA_CONTACT_FAILED_EMAIL);
                }
            }
        }
        if (!emailSent && !smsSent) {
            if (mapOfAllRecipients.isEmpty()) {
                LOGGER.debug("No recipients found for [{}]", (Object)principal.getId());
                return this.getEventFactorySupport().event((Object)this, "register", (AttributeMap)new LocalAttributeMap(Map.of("principal", principal, "authentication", authentication)));
            }
            List emailRecipients = mapOfAllRecipients.getOrDefault((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.EMAIL, List.of());
            List smsRecipients = mapOfAllRecipients.getOrDefault((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.SMS, List.of());
            if (emailRecipients.size() > 1 || smsRecipients.size() > 1) {
                LOGGER.debug("Multiple recipients found for [{}]: [{}]", (Object)principal.getId(), mapOfAllRecipients);
                return this.buildSelectRecipientsEvent(requestContext, principal, mapOfAllRecipients);
            }
        }
        boolean notificationSent = communicationStrategy.contains((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.NOTIFICATION) && this.isNotificationSent(principal, (Ticket)token);
        boolean bl = phoneCallSent = communicationStrategy.contains((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.PHONE) && CasSimpleMultifactorMakePhoneCall.of(this.communicationsManager, this.properties).call(principal, (Ticket)token, requestContext);
        if (smsSent || emailSent || notificationSent || phoneCallSent) {
            LOGGER.debug("Successfully submitted token via strategy option [{}] to [{}]", communicationStrategy, (Object)principal.getId());
            this.storeToken(requestContext, token);
            return this.buildSuccessEvent(token);
        }
        LOGGER.error("Communication strategies failed to submit token [{}] to user", (Object)token.getId());
        return this.error();
    }

    protected List<String> findSelectedEmailRecipients(RequestContext requestContext, Principal principal) {
        Map<String, CandidateRecipientAddress> recipients = CasSimpleMultifactorSendTokenAction.getEmailRecipients(requestContext);
        return CasSimpleMultifactorSendTokenAction.findSelectedRecipients(requestContext, recipients);
    }

    protected List<String> findSelectedSmsRecipients(RequestContext requestContext, Principal principal) {
        Map<String, CandidateRecipientAddress> recipients = CasSimpleMultifactorSendTokenAction.getSmsRecipients(requestContext);
        return CasSimpleMultifactorSendTokenAction.findSelectedRecipients(requestContext, recipients);
    }

    private static List<String> findSelectedRecipients(RequestContext requestContext, Map<String, CandidateRecipientAddress> recipients) {
        if (recipients == null || recipients.isEmpty()) {
            LOGGER.debug("No selected SMS recipients are found in the request context");
            return List.of();
        }
        Map parameters = requestContext.getRequestParameters().asMap();
        return parameters.keySet().stream().filter(recipients::containsKey).map(entry -> ((CandidateRecipientAddress)recipients.get(entry)).contact()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Event buildSelectRecipientsEvent(RequestContext requestContext, Principal principal, Map<CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions, List<String>> recipients) {
        List<String> smsRecipients;
        LocalAttributeMap eventAttributes = new LocalAttributeMap();
        List<String> emailRecipients = recipients.get((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.EMAIL);
        if (emailRecipients != null) {
            Pattern emailDomainPattern = Pattern.compile(".{2}@.{2}");
            Map<String, CandidateRecipientAddress> validAddresses = emailRecipients.stream().map(address -> {
                String hash = DigestUtils.sha512((String)address);
                String obfuscated = emailDomainPattern.matcher((CharSequence)address).replaceAll("****@****");
                return Pair.of((Object)hash, (Object)new CandidateRecipientAddress(CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.EMAIL, hash, (String)address, obfuscated));
            }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            CasSimpleMultifactorSendTokenAction.putEmailRecipients(requestContext, validAddresses);
            LOGGER.debug("Multiple emails found for [{}]: [{}]", (Object)principal.getId(), validAddresses);
            eventAttributes.put(FLOW_SCOPE_ATTR_EMAIL_RECIPIENTS, validAddresses);
        }
        if ((smsRecipients = recipients.get((Object)CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.SMS)) != null) {
            Pattern phonePattern = Pattern.compile("\\d{4}$");
            Map<String, CandidateRecipientAddress> validPhones = smsRecipients.stream().map(address -> {
                String hash = DigestUtils.sha512((String)address);
                String obfuscated = phonePattern.matcher((CharSequence)address).replaceAll("******");
                return Pair.of((Object)hash, (Object)new CandidateRecipientAddress(CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions.SMS, hash, (String)address, obfuscated));
            }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            CasSimpleMultifactorSendTokenAction.putSmsRecipients(requestContext, validPhones);
            LOGGER.debug("Multiple phone numbers found for [{}]: [{}]", (Object)principal.getId(), validPhones);
            eventAttributes.put(FLOW_SCOPE_ATTR_SMS_RECIPIENTS, validPhones);
        }
        WebUtils.putPrincipal((RequestContext)requestContext, (Principal)principal);
        return new EventFactorySupport().event((Object)this, "select", (AttributeMap)eventAttributes);
    }

    private static void putSmsRecipients(RequestContext requestContext, Map<String, CandidateRecipientAddress> validPhones) {
        requestContext.getFlowScope().put(FLOW_SCOPE_ATTR_SMS_RECIPIENTS, validPhones);
    }

    private static void putEmailRecipients(RequestContext requestContext, Map<String, CandidateRecipientAddress> validAddresses) {
        requestContext.getFlowScope().put(FLOW_SCOPE_ATTR_EMAIL_RECIPIENTS, validAddresses);
    }

    private static Map<String, CandidateRecipientAddress> getEmailRecipients(RequestContext requestContext) {
        return (Map)requestContext.getFlowScope().get(FLOW_SCOPE_ATTR_EMAIL_RECIPIENTS, Map.class);
    }

    private static Map<String, CandidateRecipientAddress> getSmsRecipients(RequestContext requestContext) {
        return (Map)requestContext.getFlowScope().get(FLOW_SCOPE_ATTR_SMS_RECIPIENTS, Map.class);
    }

    protected Event buildSuccessEvent(CasSimpleMultifactorAuthenticationTicket token) {
        LocalAttributeMap attributes = new LocalAttributeMap("token", (Object)token.getId());
        return new EventFactorySupport().event((Object)this, "success", (AttributeMap)attributes);
    }

    protected void storeToken(RequestContext requestContext, CasSimpleMultifactorAuthenticationTicket token) throws Throwable {
        this.multifactorAuthenticationService.store(token);
        WebUtils.addInfoMessageToContext((RequestContext)requestContext, (String)MESSAGE_MFA_TOKEN_SENT);
        MultifactorAuthenticationWebflowUtils.putSimpleMultifactorAuthenticationToken((RequestContext)requestContext, (Ticket)token);
    }

    protected CasSimpleMultifactorAuthenticationTicket getOrCreateToken(RequestContext requestContext, Principal principal) {
        CasSimpleMultifactorAuthenticationTicket currentToken = (CasSimpleMultifactorAuthenticationTicket)MultifactorAuthenticationWebflowUtils.getSimpleMultifactorAuthenticationToken((RequestContext)requestContext, CasSimpleMultifactorAuthenticationTicket.class);
        return Optional.ofNullable(currentToken).filter(token -> !token.isExpired()).orElseGet(Unchecked.supplier(() -> {
            MultifactorAuthenticationWebflowUtils.removeSimpleMultifactorAuthenticationToken((RequestContext)requestContext);
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            return this.multifactorAuthenticationService.generate(principal, (Service)service);
        }));
    }

    private String getThrottledRequestKeyFor(Authentication authentication, RequestContext requestContext) {
        Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
        return principal.getId();
    }

    @Generated
    public CasSimpleMultifactorSendTokenAction(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationService multifactorAuthenticationService, CasSimpleMultifactorAuthenticationProperties properties, CasSimpleMultifactorTokenCommunicationStrategy tokenCommunicationStrategy, BucketConsumer bucketConsumer) {
        this.communicationsManager = communicationsManager;
        this.multifactorAuthenticationService = multifactorAuthenticationService;
        this.properties = properties;
        this.tokenCommunicationStrategy = tokenCommunicationStrategy;
        this.bucketConsumer = bucketConsumer;
    }

    public record CandidateRecipientAddress(CasSimpleMultifactorTokenCommunicationStrategy.TokenSharingStrategyOptions option, String hash, String contact, String obfuscated) implements Serializable
    {
    }
}

