/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.execution.RequestContext;

class CasSimpleMultifactorSendEmail {
    private final CommunicationsManager communicationsManager;
    private final CasSimpleMultifactorAuthenticationProperties properties;

    protected EmailCommunicationResults send(Principal principal, Ticket tokenTicket, List<String> recipients, RequestContext requestContext) {
        List results = (List)FunctionUtils.doIf((boolean)this.communicationsManager.isMailSenderDefined(), () -> {
            EmailMessageBodyBuilder body = this.prepareEmailMessageBody(principal, tokenTicket, requestContext);
            return List.of(this.sendEmail(requestContext, body, principal, recipients));
        }, () -> List.of(EmailCommunicationResult.builder().success(false).build())).get();
        return new EmailCommunicationResults(results);
    }

    protected EmailCommunicationResults send(Principal principal, Ticket tokenTicket, RequestContext requestContext) {
        List results = (List)FunctionUtils.doIf((boolean)this.communicationsManager.isMailSenderDefined(), () -> {
            EmailMessageBodyBuilder body = this.prepareEmailMessageBody(principal, tokenTicket, requestContext);
            return this.properties.getMail().getAttributeName().stream().map(attribute -> this.sendEmail(requestContext, body, principal, (String)attribute)).collect(Collectors.toList());
        }, () -> List.of(EmailCommunicationResult.builder().success(false).build())).get();
        return new EmailCommunicationResults(results);
    }

    protected EmailCommunicationResult sendEmail(RequestContext requestContext, EmailMessageBodyBuilder body, Principal principal, List<String> recipients) {
        EmailMessageRequest emailRequest = this.prepareEmailMessageRequest(requestContext, body, principal, "").withTo(recipients);
        return this.communicationsManager.email(emailRequest);
    }

    protected EmailCommunicationResult sendEmail(RequestContext requestContext, EmailMessageBodyBuilder body, Principal principal, String attribute) {
        EmailMessageRequest emailRequest = this.prepareEmailMessageRequest(requestContext, body, principal, attribute);
        return this.communicationsManager.email(emailRequest);
    }

    protected List<String> getEmailMessageRecipients(Principal principal) {
        return this.properties.getMail().getAttributeName().stream().map(attribute -> EmailMessageRequest.builder().emailProperties(this.properties.getMail()).principal(principal).attribute(SpringExpressionLanguageValueResolver.getInstance().resolve(attribute)).build().getRecipients()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    protected EmailMessageRequest prepareEmailMessageRequest(RequestContext requestContext, EmailMessageBodyBuilder bodyBuilder, Principal principal, String attribute) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        Optional<Locale> locale = Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).map(resolver -> resolver.resolveLocale(request));
        return EmailMessageRequest.builder().emailProperties(this.properties.getMail()).locale(locale.orElseGet(Locale::getDefault)).principal(principal).attribute(SpringExpressionLanguageValueResolver.getInstance().resolve(attribute)).body(bodyBuilder.get()).context(bodyBuilder.getParameters()).build();
    }

    protected EmailMessageBodyBuilder prepareEmailMessageBody(Principal principal, Ticket tokenTicket, RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        Optional<Locale> locale = Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).map(resolver -> resolver.resolveLocale(request));
        Map<String, Object> parameters = this.buildEmailBodyParameters(principal, tokenTicket);
        return EmailMessageBodyBuilder.builder().properties(this.properties.getMail()).locale(locale).parameters(parameters).build();
    }

    protected Map<String, Object> buildEmailBodyParameters(Principal principal, Ticket tokenTicket) {
        Map parameters = CoreAuthenticationUtils.convertAttributeValuesToObjects((Map)principal.getAttributes());
        String token = tokenTicket.getId();
        String tokenWithoutPrefix = token.substring("CASMFA".length() + 1);
        parameters.put("token", token);
        parameters.put("tokenWithoutPrefix", tokenWithoutPrefix);
        return parameters;
    }

    @Generated
    private CasSimpleMultifactorSendEmail(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationProperties properties) {
        this.communicationsManager = communicationsManager;
        this.properties = properties;
    }

    @Generated
    protected static CasSimpleMultifactorSendEmail of(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationProperties properties) {
        return new CasSimpleMultifactorSendEmail(communicationsManager, properties);
    }

    record EmailCommunicationResults(List<EmailCommunicationResult> results) {
        boolean isAnyEmailSent() {
            return this.results.stream().anyMatch(EmailCommunicationResult::isSuccess);
        }
    }
}

