/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.validation;

import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasSimpleMultifactorAuthenticationService
implements CasSimpleMultifactorAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasSimpleMultifactorAuthenticationService.class);
    protected final TicketRegistry ticketRegistry;
    protected final TicketFactory ticketFactory;

    @Override
    public CasSimpleMultifactorAuthenticationTicket generate(Principal principal, Service service) throws Throwable {
        CasSimpleMultifactorAuthenticationTicketFactory mfaFactory = (CasSimpleMultifactorAuthenticationTicketFactory)this.ticketFactory.get(CasSimpleMultifactorAuthenticationTicket.class);
        CasSimpleMultifactorAuthenticationTicket token = mfaFactory.create(service, CollectionUtils.wrap((String)"principal", (Object)principal));
        LOGGER.debug("Created multifactor authentication token [{}] for service [{}]", (Object)token.getId(), (Object)service);
        return token;
    }

    @Override
    public void store(CasSimpleMultifactorAuthenticationTicket token) {
        token.update();
        Ticket trackingToken = this.ticketRegistry.getTicket(token.getId());
        FunctionUtils.doUnchecked(us -> {
            if (trackingToken != null) {
                LOGGER.debug("Updating existing token [{}] to registry", (Object)token.getId());
                this.ticketRegistry.updateTicket(trackingToken);
            } else {
                LOGGER.debug("Adding token [{}] to registry", (Object)token.getId());
                this.ticketRegistry.addTicket((Ticket)token);
            }
        }, (Object[])new Object[0]);
    }

    @Override
    public Principal fetch(CasSimpleMultifactorTokenCredential tokenCredential) {
        return Optional.ofNullable(this.getMultifactorAuthenticationTicketFor(tokenCredential)).map(acct -> acct.getProperties().get("principal")).map(Principal.class::cast).orElse(null);
    }

    @Override
    public Principal validate(Principal resolvedPrincipal, CasSimpleMultifactorTokenCredential credential) throws Exception {
        CasSimpleMultifactorAuthenticationTicket acct = this.getMultifactorAuthenticationTicketFor(credential);
        LOGGER.debug("Received token [{}] and principal id [{}]", (Object)acct, (Object)resolvedPrincipal.getId());
        Principal principal = this.validateTokenForPrincipal(resolvedPrincipal, acct);
        this.deleteToken(acct);
        LOGGER.debug("Validated token [{}] successfully for [{}].", (Object)credential.getId(), (Object)resolvedPrincipal.getId());
        return principal;
    }

    protected CasSimpleMultifactorAuthenticationTicket getMultifactorAuthenticationTicketFor(CasSimpleMultifactorTokenCredential credential) {
        String tokenId = DefaultCasSimpleMultifactorAuthenticationService.normalize(credential.getId());
        return (CasSimpleMultifactorAuthenticationTicket)this.ticketRegistry.getTicket(tokenId, CasSimpleMultifactorAuthenticationTicket.class);
    }

    protected Principal validateTokenForPrincipal(Principal resolvedPrincipal, CasSimpleMultifactorAuthenticationTicket acct) throws FailedLoginException {
        if (!acct.getProperties().containsKey("principal")) {
            LOGGER.warn("Unable to locate principal for token [{}]", (Object)acct.getId());
            this.deleteToken(acct);
            throw new FailedLoginException("Failed to authenticate code " + acct.getId());
        }
        Principal principal = (Principal)acct.getProperties().get("principal");
        if (!principal.equals((Object)resolvedPrincipal)) {
            LOGGER.warn("Principal assigned to token [{}] is unauthorized for token [{}]", (Object)principal.getId(), (Object)acct.getId());
            this.deleteToken(acct);
            throw new FailedLoginException("Failed to authenticate code " + acct.getId());
        }
        return principal;
    }

    protected static String normalize(String tokenId) {
        if (!tokenId.startsWith("CASMFA")) {
            return "CASMFA-" + tokenId;
        }
        return tokenId;
    }

    protected void deleteToken(CasSimpleMultifactorAuthenticationTicket acct) {
        FunctionUtils.doUnchecked(__ -> this.ticketRegistry.deleteTicket(acct.getId()), (Object[])new Object[0]);
    }

    @Generated
    public DefaultCasSimpleMultifactorAuthenticationService(TicketRegistry ticketRegistry, TicketFactory ticketFactory) {
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
    }
}

