/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications.mail;

import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.springframework.context.HierarchicalMessageSource;

@FunctionalInterface
public interface EmailSender {
    public static final String BEAN_NAME = "emailSender";

    default public boolean canSend() {
        return true;
    }

    public EmailCommunicationResult send(EmailMessageRequest var1) throws Exception;

    default public String determineEmailSubject(EmailMessageRequest emailRequest, HierarchicalMessageSource messageSource) {
        StringSubstitutor substitutor = new StringSubstitutor(emailRequest.getContext(), "${", "}");
        String subject = substitutor.replace(emailRequest.getEmailProperties().getSubject());
        Pattern pattern = RegexUtils.createPattern((String)"#\\{(.+)\\}");
        Matcher matcher = pattern.matcher(subject);
        if (matcher.find()) {
            ArrayList<String> args = new ArrayList<String>();
            if (emailRequest.getPrincipal() != null) {
                args.add(emailRequest.getPrincipal().getId());
            }
            return messageSource.getMessage(matcher.group(1), args.toArray(), "Email Subject", (Locale)ObjectUtils.defaultIfNull((Object)emailRequest.getLocale(), (Object)Locale.getDefault()));
        }
        return SpringExpressionLanguageValueResolver.getInstance().resolve(subject);
    }
}

