/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.call.PhoneCallOperator;
import org.apereo.cas.notifications.call.PhoneCallRequest;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.mail.EmailSender;
import org.apereo.cas.notifications.push.NotificationSender;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.notifications.sms.SmsSender;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommunicationsManager
implements CommunicationsManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCommunicationsManager.class);
    private final SmsSender smsSender;
    private final EmailSender emailSender;
    private final NotificationSender notificationSender;
    private final PhoneCallOperator phoneCallOperator;

    @Override
    public boolean isPhoneOperatorDefined() {
        return this.phoneCallOperator != null && this.phoneCallOperator.canCall();
    }

    @Override
    public boolean isMailSenderDefined() {
        return this.emailSender != null && this.emailSender.canSend();
    }

    @Override
    public boolean isSmsSenderDefined() {
        return this.smsSender != null && this.smsSender.canSend();
    }

    @Override
    public boolean isNotificationSenderDefined() {
        return this.notificationSender != null && this.notificationSender.canSend();
    }

    @Override
    public boolean notify(Principal principal, String title, String body) {
        return this.notificationSender.notify(principal, Map.of("title", title, "message", body));
    }

    @Override
    public EmailCommunicationResult email(EmailMessageRequest emailRequest) {
        List<String> recipients = Objects.requireNonNull(emailRequest.getRecipients(), "Email recipients cannot be undefined");
        LOGGER.trace("Attempting to send email [{}] to [{}]", (Object)emailRequest.getBody(), recipients);
        return (EmailCommunicationResult)FunctionUtils.doIf((this.isMailSenderDefined() && emailRequest.getEmailProperties().isDefined() && !recipients.isEmpty() ? 1 : 0) != 0, (Supplier)Unchecked.supplier(() -> this.emailSender.send(emailRequest)), () -> ((EmailCommunicationResult.EmailCommunicationResultBuilder)((EmailCommunicationResult.EmailCommunicationResultBuilder)((EmailCommunicationResult.EmailCommunicationResultBuilder)EmailCommunicationResult.builder().success(false)).to(recipients)).body(emailRequest.getBody())).build()).get();
    }

    @Override
    public boolean sms(SmsRequest smsRequest) throws Throwable {
        List<String> recipients = Objects.requireNonNull(smsRequest.getRecipients(), "SMS recipients cannot be undefined");
        if (!this.isSmsSenderDefined() || !smsRequest.isSufficient()) {
            LOGGER.warn("Could not send SMS to [{}]; No from/text is found or SMS settings are undefined.", recipients);
            return false;
        }
        return recipients.stream().anyMatch(Unchecked.predicate(to -> this.smsSender.send(smsRequest.getFrom(), (String)to, smsRequest.getText())));
    }

    @Override
    public boolean phoneCall(PhoneCallRequest request) throws Throwable {
        String recipient = request.getRecipient();
        if (!this.isPhoneOperatorDefined() || !request.isSufficient()) {
            LOGGER.warn("Could not make phone calls to [{}]; No destination phone number is found or phone operator settings are undefined.", (Object)recipient);
            return false;
        }
        return this.phoneCallOperator.call(request.getFrom(), recipient, request.getText());
    }

    @Override
    public boolean validate() {
        if (!this.isMailSenderDefined()) {
            LOGGER.info("CAS will not send emails because settings are undefined to account for email servers");
        }
        if (!this.isSmsSenderDefined()) {
            LOGGER.info("CAS will not send sms messages because settings are undefined to account for sms providers");
        }
        if (!this.isNotificationSenderDefined()) {
            LOGGER.info("CAS will not send notifications because providers are undefined to handle messages");
        }
        if (!this.isNotificationSenderDefined()) {
            LOGGER.info("CAS will not make phone calls because providers are undefined to handle phone operations");
        }
        return this.isMailSenderDefined() || this.isSmsSenderDefined() || this.isNotificationSenderDefined() || this.isPhoneOperatorDefined();
    }

    @Generated
    public DefaultCommunicationsManager(SmsSender smsSender, EmailSender emailSender, NotificationSender notificationSender, PhoneCallOperator phoneCallOperator) {
        this.smsSender = smsSender;
        this.emailSender = emailSender;
        this.notificationSender = notificationSender;
        this.phoneCallOperator = phoneCallOperator;
    }
}

