/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.TicketValidationResult;
import org.apereo.cas.validation.TicketValidator;

public class InternalTicketValidator
implements TicketValidator {
    private final CentralAuthenticationService centralAuthenticationService;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    private final AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;
    private final ServicesManager servicesManager;

    public TicketValidationResult validate(String ticketId, String serviceId) throws Throwable {
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(serviceId);
        Assertion assertion = this.centralAuthenticationService.validateServiceTicket(ticketId, (Service)service);
        Authentication authentication = assertion.getPrimaryAuthentication();
        Principal principal = authentication.getPrincipal();
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        Map authenticationAttributes = this.authenticationAttributeReleasePolicy.getAuthenticationAttributesForRelease(authentication, assertion, new HashMap(0), registeredService);
        return TicketValidationResult.builder().principal(principal).service((Service)service).attributes(authenticationAttributes).assertion(assertion).registeredService(registeredService).build();
    }

    @Generated
    public InternalTicketValidator(CentralAuthenticationService centralAuthenticationService, ServiceFactory<WebApplicationService> webApplicationServiceFactory, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, ServicesManager servicesManager) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.authenticationAttributeReleasePolicy = authenticationAttributeReleasePolicy;
        this.servicesManager = servicesManager;
    }
}

