/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.pubsub.queue;

import lombok.Generated;
import org.apereo.cas.ticket.registry.pubsub.QueueableTicketRegistry;
import org.apereo.cas.ticket.registry.pubsub.commands.BaseMessageQueueCommand;
import org.apereo.cas.ticket.registry.pubsub.queue.QueueableTicketRegistryMessageReceiver;
import org.apereo.cas.util.PublisherIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQueueableTicketRegistryMessageReceiver
implements QueueableTicketRegistryMessageReceiver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseQueueableTicketRegistryMessageReceiver.class);
    private final QueueableTicketRegistry ticketRegistry;
    private final PublisherIdentifier ticketRegistryId;

    @Override
    public void receive(BaseMessageQueueCommand command) throws Exception {
        LOGGER.debug("[{}] received message [{}]", (Object)this.ticketRegistryId, (Object)command);
        if (command.getId().equals((Object)this.ticketRegistryId)) {
            LOGGER.trace("Ignoring inbound command on ticket registry with id [{}]", (Object)this.ticketRegistryId);
        } else {
            LOGGER.debug("Accepting message from ticket registry id [{}]. Executing command [{}]", (Object)command.getId(), (Object)command);
            command.withId(this.ticketRegistryId).execute(this.ticketRegistry);
        }
    }

    @Generated
    public BaseQueueableTicketRegistryMessageReceiver(QueueableTicketRegistry ticketRegistry, PublisherIdentifier ticketRegistryId) {
        this.ticketRegistry = ticketRegistry;
        this.ticketRegistryId = ticketRegistryId;
    }

    @Generated
    public QueueableTicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public PublisherIdentifier getTicketRegistryId() {
        return this.ticketRegistryId;
    }
}

