/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.pubsub.commands;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.pubsub.QueueableTicketRegistry;
import org.apereo.cas.ticket.registry.pubsub.commands.BaseMessageQueueCommand;
import org.apereo.cas.util.PublisherIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class AddTicketMessageQueueCommand
extends BaseMessageQueueCommand {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AddTicketMessageQueueCommand.class);
    private static final long serialVersionUID = -7698722632898271240L;
    private final Ticket ticket;

    @JsonCreator
    public AddTicketMessageQueueCommand(@JsonProperty(value="id") PublisherIdentifier id, @JsonProperty(value="ticket") Ticket ticket) {
        super(id);
        this.ticket = ticket;
    }

    @Override
    public void execute(QueueableTicketRegistry registry) throws Exception {
        LOGGER.debug("Executing queue command on ticket registry id [{}] to add ticket [{}]", (Object)this.getId().getId(), (Object)this.ticket);
        registry.addTicketToQueue(this.ticket);
    }

    @Override
    public BaseMessageQueueCommand withId(PublisherIdentifier id) {
        return new AddTicketMessageQueueCommand(id, this.ticket);
    }

    @Generated
    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    @Generated
    public String toString() {
        return "AddTicketMessageQueueCommand(super=" + super.toString() + ", ticket=" + String.valueOf(this.ticket) + ")";
    }
}

