/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.ticket.EncodedTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEncodedTicket
implements EncodedTicket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEncodedTicket.class);
    private static final long serialVersionUID = -7078771807487764116L;
    private final String id;
    private final byte[] encodedTicket;
    private final String prefix;
    private boolean stateless;
    private ExpirationPolicy expirationPolicy;

    @JsonCreator
    public DefaultEncodedTicket(@JsonProperty(value="encoded") String encodedTicket, @JsonProperty(value="id") String encodedTicketId, @JsonProperty(value="prefix") String prefix) {
        this.id = encodedTicketId;
        this.encodedTicket = EncodingUtils.decodeBase64((String)encodedTicket);
        this.prefix = prefix;
    }

    public DefaultEncodedTicket(@JsonProperty(value="encoded") String encodedTicket, @JsonProperty(value="prefix") String prefix) {
        this.id = encodedTicket;
        this.prefix = prefix;
        this.encodedTicket = ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    @JsonIgnore
    public int compareTo(Ticket o) {
        return this.getId().compareTo(o.getId());
    }

    @CanIgnoreReturnValue
    public Ticket markTicketStateless() {
        this.stateless = true;
        return this;
    }

    @Generated
    public String toString() {
        return "DefaultEncodedTicket(id=" + this.id + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public byte[] getEncodedTicket() {
        return this.encodedTicket;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public boolean isStateless() {
        return this.stateless;
    }

    @Generated
    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @Generated
    public DefaultEncodedTicket() {
        this.id = null;
        this.encodedTicket = null;
        this.prefix = null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultEncodedTicket)) {
            return false;
        }
        DefaultEncodedTicket other = (DefaultEncodedTicket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultEncodedTicket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public DefaultEncodedTicket(String id, byte[] encodedTicket, String prefix) {
        this.id = id;
        this.encodedTicket = encodedTicket;
        this.prefix = prefix;
    }

    @Generated
    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }
}

