/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.factory;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTicketGrantingTicketFactory
implements TicketGrantingTicketFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTicketGrantingTicketFactory.class);
    protected final UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    protected final ExpirationPolicyBuilder<TicketGrantingTicket> expirationPolicyBuilder;
    protected final CipherExecutor<Serializable, String> cipherExecutor;
    protected final ServicesManager servicesManager;

    public <T extends TicketGrantingTicket> T create(Authentication authentication, Service service, Class<T> clazz) throws Throwable {
        String tgtId = this.produceTicketIdentifier(authentication);
        return this.produceTicket(authentication, tgtId, service, clazz);
    }

    public Class<? extends Ticket> getTicketType() {
        return TicketGrantingTicket.class;
    }

    protected <T extends TicketGrantingTicket> T produceTicket(Authentication authentication, String tgtId, Service service, Class<T> clazz) {
        Optional<ExpirationPolicy> expirationPolicy = this.getExpirationPolicyBuilder(service, authentication);
        TicketGrantingTicketImpl result = new TicketGrantingTicketImpl(tgtId, authentication, expirationPolicy.orElseThrow());
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Result [" + String.valueOf(result) + "] is of type " + String.valueOf(result.getClass()) + " when we were expecting " + String.valueOf(clazz));
        }
        return (T)result;
    }

    protected Optional<ExpirationPolicy> getExpirationPolicyBuilder(Service service, Authentication authentication) {
        Long timeout;
        Map allAttributes = CoreAuthenticationUtils.mergeAttributes((Map)authentication.getAttributes(), (Map)authentication.getPrincipal().getAttributes());
        if (allAttributes.containsKey("authenticationSessionTimeout") && (timeout = CollectionUtils.firstElement(allAttributes.get("authenticationSessionTimeout")).map(value -> NumberUtils.isDigits((String)value.toString()) ? NumberUtils.toLong((String)value.toString()) : Beans.newDuration((String)value.toString()).toSeconds()).orElse(-1L)) >= 0L) {
            return Optional.of(new HardTimeoutExpirationPolicy(timeout));
        }
        return Optional.ofNullable(this.servicesManager.findServiceBy(service)).map(RegisteredService::getTicketGrantingTicketExpirationPolicy).flatMap(RegisteredServiceTicketGrantingTicketExpirationPolicy::toExpirationPolicy).or(() -> Optional.of(this.expirationPolicyBuilder.buildTicketExpirationPolicy()));
    }

    protected String produceTicketIdentifier(Authentication authentication) throws Throwable {
        String tgtId = this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT");
        if (this.cipherExecutor != null && this.cipherExecutor.isEnabled()) {
            LOGGER.trace("Attempting to encode ticket-granting ticket [{}]", (Object)tgtId);
            tgtId = (String)this.cipherExecutor.encode((Object)tgtId);
            LOGGER.trace("Encoded ticket-granting ticket id [{}]", (Object)tgtId);
        }
        return tgtId;
    }

    @Generated
    public DefaultTicketGrantingTicketFactory(UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator, ExpirationPolicyBuilder<TicketGrantingTicket> expirationPolicyBuilder, CipherExecutor<Serializable, String> cipherExecutor, ServicesManager servicesManager) {
        this.ticketGrantingTicketUniqueTicketIdGenerator = ticketGrantingTicketUniqueTicketIdGenerator;
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.cipherExecutor = cipherExecutor;
        this.servicesManager = servicesManager;
    }

    @Generated
    public ExpirationPolicyBuilder<TicketGrantingTicket> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }
}

