/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.factory;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.expiration.MultiTimeUseOrTimeoutExpirationPolicy;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.ticket.proxy.ProxyTicketFactory;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.apereo.cas.util.HostNameBasedUniqueTicketIdGenerator;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyTicketFactory
implements ProxyTicketFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProxyTicketFactory.class);
    private final UniqueTicketIdGenerator defaultTicketIdGenerator = new HostNameBasedUniqueTicketIdGenerator();
    private final ExpirationPolicyBuilder<ProxyTicket> expirationPolicyBuilder;
    private final Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    private final CipherExecutor<String, String> cipherExecutor;
    private final TicketTrackingPolicy serviceTicketSessionTrackingPolicy;
    private final ServicesManager servicesManager;

    public <T extends Ticket> T create(ProxyGrantingTicket proxyGrantingTicket, Service service, Class<T> clazz) throws Throwable {
        String ticketId = this.produceTicketIdentifier(service);
        return this.produceTicket(proxyGrantingTicket, service, ticketId, clazz);
    }

    public Class<? extends Ticket> getTicketType() {
        return ProxyTicket.class;
    }

    protected <T extends Ticket> T produceTicket(ProxyGrantingTicket proxyGrantingTicket, Service service, String ticketId, Class<T> clazz) {
        ExpirationPolicy expirationPolicyToUse = this.determineExpirationPolicyForService(service);
        ProxyTicket result = proxyGrantingTicket.grantProxyTicket(ticketId, service, expirationPolicyToUse, this.serviceTicketSessionTrackingPolicy);
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Result [" + String.valueOf(result) + " is of type " + String.valueOf(result.getClass()) + " when we were expecting " + String.valueOf(clazz));
        }
        return (T)result;
    }

    protected String produceTicketIdentifier(Service service) throws Throwable {
        String uniqueTicketIdGenKey = service.getClass().getName();
        LOGGER.debug("Looking up ticket id generator for [{}]", (Object)uniqueTicketIdGenKey);
        UniqueTicketIdGenerator generator = this.uniqueTicketIdGeneratorsForService.get(uniqueTicketIdGenKey);
        if (generator == null) {
            generator = this.defaultTicketIdGenerator;
            LOGGER.debug("Ticket id generator not found for [{}]. Using the default generator...", (Object)uniqueTicketIdGenKey);
        }
        String ticketId = generator.getNewTicketId("PT");
        if (this.cipherExecutor == null || !this.cipherExecutor.isEnabled()) {
            return ticketId;
        }
        LOGGER.trace("Attempting to encode proxy ticket [{}]", (Object)ticketId);
        String encodedId = (String)this.cipherExecutor.encode((Object)ticketId);
        LOGGER.debug("Encoded proxy ticket id [{}]", (Object)encodedId);
        return encodedId;
    }

    private ExpirationPolicy determineExpirationPolicyForService(Service service) {
        CasModelRegisteredService registeredService = (CasModelRegisteredService)this.servicesManager.findServiceBy(service, CasModelRegisteredService.class);
        if (registeredService != null && registeredService.getProxyTicketExpirationPolicy() != null) {
            RegisteredServiceProxyTicketExpirationPolicy policy = registeredService.getProxyTicketExpirationPolicy();
            long count = policy.getNumberOfUses();
            String ttl = policy.getTimeToLive();
            if (count > 0L && StringUtils.isNotBlank((CharSequence)ttl)) {
                return new MultiTimeUseOrTimeoutExpirationPolicy.ProxyTicketExpirationPolicy(count, Beans.newDuration((String)ttl).getSeconds());
            }
        }
        return this.expirationPolicyBuilder.buildTicketExpirationPolicy();
    }

    @Generated
    public DefaultProxyTicketFactory(ExpirationPolicyBuilder<ProxyTicket> expirationPolicyBuilder, Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService, CipherExecutor<String, String> cipherExecutor, TicketTrackingPolicy serviceTicketSessionTrackingPolicy, ServicesManager servicesManager) {
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
        this.cipherExecutor = cipherExecutor;
        this.serviceTicketSessionTrackingPolicy = serviceTicketSessionTrackingPolicy;
        this.servicesManager = servicesManager;
    }

    @Generated
    public ExpirationPolicyBuilder<ProxyTicket> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }
}

