/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.catalog;

import java.util.function.Function;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.springframework.context.ConfigurableApplicationContext;

public interface CasTicketCatalogConfigurationValuesProvider {
    public static final String STORAGE_NAME_SERVICE_TICKETS = "serviceTicketsCache";
    public static final String STORAGE_NAME_PROXY_TICKET = "proxyTicketsCache";
    public static final String STORAGE_NAME_TICKET_GRANTING_TICKETS = "ticketGrantingTicketsCache";
    public static final String STORAGE_NAME_PROXY_GRANTING_TICKETS = "proxyGrantingTicketsCache";
    public static final String STORAGE_NAME_TRANSIENT_SESSION_TICKETS = "transientSessionTicketsCache";

    default public Function<ConfigurableApplicationContext, Long> getServiceTicketStorageTimeout() {
        return ctx -> ((ExpirationPolicyBuilder)ctx.getBean("serviceTicketExpirationPolicy", ExpirationPolicyBuilder.class)).buildTicketExpirationPolicy().getTimeToLive();
    }

    default public Function<CasConfigurationProperties, String> getServiceTicketStorageName() {
        return __ -> STORAGE_NAME_SERVICE_TICKETS;
    }

    default public Function<ConfigurableApplicationContext, Long> getProxyTicketStorageTimeout() {
        return ctx -> ((ExpirationPolicyBuilder)ctx.getBean("proxyTicketExpirationPolicy", ExpirationPolicyBuilder.class)).buildTicketExpirationPolicy().getTimeToLive();
    }

    default public Function<CasConfigurationProperties, String> getProxyTicketStorageName() {
        return __ -> STORAGE_NAME_PROXY_TICKET;
    }

    default public Function<ConfigurableApplicationContext, Long> getTicketGrantingTicketStorageTimeout() {
        return ctx -> ((ExpirationPolicyBuilder)ctx.getBean("grantingTicketExpirationPolicy", ExpirationPolicyBuilder.class)).buildTicketExpirationPolicy().getTimeToLive();
    }

    default public Function<CasConfigurationProperties, String> getTicketGrantingTicketStorageName() {
        return __ -> STORAGE_NAME_TICKET_GRANTING_TICKETS;
    }

    default public Function<ConfigurableApplicationContext, Long> getProxyGrantingTicketStorageTimeout() {
        return ctx -> ((ExpirationPolicyBuilder)ctx.getBean("proxyGrantingTicketExpirationPolicy", ExpirationPolicyBuilder.class)).buildTicketExpirationPolicy().getTimeToLive();
    }

    default public Function<CasConfigurationProperties, String> getProxyGrantingTicketStorageName() {
        return __ -> STORAGE_NAME_PROXY_GRANTING_TICKETS;
    }

    default public Function<ConfigurableApplicationContext, Long> getTransientSessionStorageTimeout() {
        return ctx -> ((ExpirationPolicyBuilder)ctx.getBean("transientSessionTicketExpirationPolicy", ExpirationPolicyBuilder.class)).buildTicketExpirationPolicy().getTimeToLive();
    }

    default public Function<CasConfigurationProperties, String> getTransientSessionStorageName() {
        return p -> STORAGE_NAME_TRANSIENT_SESSION_TICKETS;
    }

    default public Function<ConfigurableApplicationContext, Boolean> getProxyGrantingTicketCascadeRemovals() {
        return __ -> false;
    }

    default public Function<ConfigurableApplicationContext, Boolean> getTicketGrantingTicketCascadeRemovals() {
        return __ -> false;
    }
}

