/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.InvalidProxyGrantingTicketForServiceTicketException;
import org.apereo.cas.ticket.ProxyGrantingTicketImpl;
import org.apereo.cas.ticket.ProxyGrantingTicketIssuerTicket;
import org.apereo.cas.ticket.RenewableServiceTicket;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class ServiceTicketImpl
extends AbstractTicket
implements ServiceTicket,
RenewableServiceTicket,
ProxyGrantingTicketIssuerTicket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTicketImpl.class);
    private static final long serialVersionUID = -4223319704861765405L;
    @JsonProperty(value="ticketGrantingTicket")
    private TicketGrantingTicket ticketGrantingTicket;
    @JsonProperty(value="authentication")
    private Authentication authentication;
    private Service service;
    private boolean fromNewLogin;
    private Boolean grantedTicketAlready = Boolean.FALSE;

    @JsonCreator
    public ServiceTicketImpl(@JsonProperty(value="id") @NonNull String id, @JsonProperty(value="ticketGrantingTicket") TicketGrantingTicket ticket, @JsonProperty(value="service") @NonNull Service service, @JsonProperty(value="credentialProvided") boolean credentialProvided, @JsonProperty(value="expirationPolicy") ExpirationPolicy policy) {
        super(id, policy);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        this.ticketGrantingTicket = ticket;
        this.service = service;
        this.fromNewLogin = credentialProvided || ticket != null && ticket.getCountOfUses() == 0;
    }

    public ProxyGrantingTicket grantProxyGrantingTicket(@NonNull String id, @NonNull Authentication authentication, ExpirationPolicy expirationPolicy) throws AbstractTicketException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (authentication == null) {
            throw new NullPointerException("authentication is marked non-null but is null");
        }
        if (this.grantedTicketAlready.booleanValue()) {
            LOGGER.warn("Service ticket [{}] issued for service [{}] has already allotted a proxy-granting ticket", (Object)this.getId(), (Object)this.service.getId());
            throw new InvalidProxyGrantingTicketForServiceTicketException(this.service);
        }
        this.grantedTicketAlready = Boolean.TRUE;
        ProxyGrantingTicketImpl proxyGrantingTicket = new ProxyGrantingTicketImpl(id, this.service, this.ticketGrantingTicket, authentication, expirationPolicy);
        if (this.ticketGrantingTicket != null) {
            this.ticketGrantingTicket.getProxyGrantingTickets().put(proxyGrantingTicket.getId(), this.service);
        }
        return proxyGrantingTicket;
    }

    @Override
    @JsonIgnore
    public Authentication getAuthentication() {
        return Objects.requireNonNullElseGet(this.authentication, () -> this.ticketGrantingTicket != null ? this.ticketGrantingTicket.getAuthentication() : null);
    }

    public String getPrefix() {
        return "ST";
    }

    @JsonProperty(value="ticketGrantingTicket")
    @Generated
    public ServiceTicketImpl setTicketGrantingTicket(TicketGrantingTicket ticketGrantingTicket) {
        this.ticketGrantingTicket = ticketGrantingTicket;
        return this;
    }

    @JsonProperty(value="authentication")
    @Generated
    public ServiceTicketImpl setAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @Generated
    public ServiceTicketImpl setService(Service service) {
        this.service = service;
        return this;
    }

    @Generated
    public ServiceTicketImpl setFromNewLogin(boolean fromNewLogin) {
        this.fromNewLogin = fromNewLogin;
        return this;
    }

    @Generated
    public ServiceTicketImpl setGrantedTicketAlready(Boolean grantedTicketAlready) {
        this.grantedTicketAlready = grantedTicketAlready;
        return this;
    }

    @Generated
    public ServiceTicketImpl() {
    }

    @Generated
    public TicketGrantingTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public boolean isFromNewLogin() {
        return this.fromNewLogin;
    }

    @Generated
    public Boolean getGrantedTicketAlready() {
        return this.grantedTicketAlready;
    }
}

