/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap.mapping;

import java.util.HashSet;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyConf;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf;
import org.apache.syncope.wa.bootstrap.mapping.AttrReleaseMapper;
import org.apereo.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.RegisteredServicePrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.cache.CachingPrincipalAttributesRepository;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.ReturnMappedAttributeReleasePolicy;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;

public class DefaultAttrReleaseMapper
implements AttrReleaseMapper {
    @Override
    public boolean supports(AttrReleasePolicyConf conf) {
        return DefaultAttrReleasePolicyConf.class.equals((Object)conf.getClass());
    }

    @Override
    public RegisteredServiceAttributeReleasePolicy build(AttrReleasePolicyTO policy) {
        DefaultAttrReleasePolicyConf conf = (DefaultAttrReleasePolicyConf)policy.getConf();
        ReturnMappedAttributeReleasePolicy returnMapped = null;
        if (!conf.getReleaseAttrs().isEmpty()) {
            returnMapped = new ReturnMappedAttributeReleasePolicy();
            returnMapped.setAllowedAttributes(conf.getReleaseAttrs());
        }
        ReturnAllowedAttributeReleasePolicy returnAllowed = null;
        if (!conf.getAllowedAttrs().isEmpty()) {
            returnAllowed = new ReturnAllowedAttributeReleasePolicy();
            returnAllowed.setAllowedAttributes(conf.getAllowedAttrs());
        }
        Object attributeReleasePolicy = returnMapped == null && returnAllowed == null ? new DenyAllAttributeReleasePolicy() : (returnMapped != null ? returnMapped : returnAllowed);
        DefaultRegisteredServiceConsentPolicy consentPolicy = new DefaultRegisteredServiceConsentPolicy(new HashSet(conf.getExcludedAttrs()), new HashSet(conf.getIncludeOnlyAttrs()));
        consentPolicy.setOrder(policy.getOrder());
        consentPolicy.setStatus(TriStateBoolean.fromBoolean((boolean)policy.getStatus()));
        attributeReleasePolicy.setConsentPolicy((RegisteredServiceConsentPolicy)consentPolicy);
        if (conf.getPrincipalIdAttr() != null) {
            attributeReleasePolicy.setPrincipalIdAttribute(conf.getPrincipalIdAttr());
        }
        if (conf.getPrincipalAttrRepoConf() != null && !conf.getPrincipalAttrRepoConf().getAttrRepos().isEmpty()) {
            DefaultAttrReleasePolicyConf.PrincipalAttrRepoConf parc = conf.getPrincipalAttrRepoConf();
            CachingPrincipalAttributesRepository par = parc.getExpiration() > 0L ? new CachingPrincipalAttributesRepository(parc.getTimeUnit().name(), parc.getExpiration()) : new DefaultPrincipalAttributesRepository();
            par.setMergingStrategy(PrincipalAttributesCoreProperties.MergingStrategyTypes.valueOf((String)parc.getMergingStrategy().name()));
            par.setIgnoreResolvedAttributes(par.isIgnoreResolvedAttributes());
            par.setAttributeRepositoryIds(new HashSet(parc.getAttrRepos()));
            attributeReleasePolicy.setPrincipalAttributesRepository((RegisteredServicePrincipalAttributesRepository)par);
        }
        if (returnMapped != null && returnAllowed != null) {
            ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{returnMapped, returnAllowed});
            if (conf.getPrincipalAttrRepoConf() != null && !conf.getPrincipalAttrRepoConf().getAttrRepos().isEmpty()) {
                DefaultAttrReleasePolicyConf.PrincipalAttrRepoConf parc = conf.getPrincipalAttrRepoConf();
                chain.setMergingPolicy(PrincipalAttributesCoreProperties.MergingStrategyTypes.valueOf((String)parc.getMergingStrategy().name()));
            }
            return chain;
        }
        return attributeReleasePolicy;
    }
}

