/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.NamespaceContext;
import org.apereo.cas.client.authentication.AttributePrincipal;
import org.apereo.cas.client.authentication.AttributePrincipalImpl;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.util.IOUtils;
import org.apereo.cas.client.util.MapNamespaceContext;
import org.apereo.cas.client.util.SamlUtils;
import org.apereo.cas.client.util.ThreadLocalXPathExpression;
import org.apereo.cas.client.util.XmlUtils;
import org.apereo.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.AssertionImpl;
import org.apereo.cas.client.validation.TicketValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Saml11TicketValidator
extends AbstractUrlBasedTicketValidator {
    public static final String AUTH_METHOD_ATTRIBUTE = "samlAuthenticationStatement::authMethod";
    private static final String SAML_REQUEST_TEMPLATE;
    private static final NamespaceContext NS_CONTEXT;
    private static final ThreadLocalXPathExpression XPATH_ASSERTION_DATE_START;
    private static final ThreadLocalXPathExpression XPATH_ASSERTION_DATE_END;
    private static final ThreadLocalXPathExpression XPATH_NAME_ID;
    private static final ThreadLocalXPathExpression XPATH_AUTH_METHOD;
    private static final ThreadLocalXPathExpression XPATH_ATTRIBUTES;
    private static final String HEX_CHARS = "0123456789abcdef";
    private long tolerance = 1000L;
    private final Random random;

    public Saml11TicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot find required SHA1PRNG algorithm");
        }
    }

    protected String getUrlSuffix() {
        return "samlValidate";
    }

    protected void populateUrlAttributeMap(Map<String, String> urlParameters) {
        String service = urlParameters.get("service");
        urlParameters.remove("service");
        urlParameters.remove("ticket");
        urlParameters.put("TARGET", service);
    }

    protected Assertion parseResponseFromServer(String response) throws TicketValidationException {
        try {
            Document document = XmlUtils.newDocument((String)response);
            Date assertionValidityStart = SamlUtils.parseUtcDate(XPATH_ASSERTION_DATE_START.evaluateAsString((Object)document));
            Date assertionValidityEnd = SamlUtils.parseUtcDate(XPATH_ASSERTION_DATE_END.evaluateAsString((Object)document));
            if (!this.isValidAssertion(assertionValidityStart, assertionValidityEnd)) {
                throw new TicketValidationException("Invalid SAML assertion");
            }
            String nameId = XPATH_NAME_ID.evaluateAsString((Object)document);
            if (nameId == null) {
                throw new TicketValidationException("SAML assertion does not contain NameIdentifier element");
            }
            String authMethod = XPATH_AUTH_METHOD.evaluateAsString((Object)document);
            NodeList attributes = XPATH_ATTRIBUTES.evaluateAsNodeList((Object)document);
            HashMap<String, Object> principalAttributes = new HashMap<String, Object>(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                Element attribute = (Element)attributes.item(i);
                String name = attribute.getAttribute("AttributeName");
                this.logger.trace("Processing attribute {}", (Object)name);
                NodeList values = attribute.getElementsByTagNameNS("*", "AttributeValue");
                if (values.getLength() == 1) {
                    principalAttributes.put(name, values.item(0).getTextContent());
                    continue;
                }
                ArrayList<String> items = new ArrayList<String>(values.getLength());
                for (int j = 0; j < values.getLength(); ++j) {
                    items.add(values.item(j).getTextContent());
                }
                principalAttributes.put(name, items);
            }
            return new AssertionImpl((AttributePrincipal)new AttributePrincipalImpl(nameId, principalAttributes), assertionValidityStart, assertionValidityEnd, new Date(), Collections.singletonMap(AUTH_METHOD_ATTRIBUTE, authMethod));
        }
        catch (Exception e) {
            throw new TicketValidationException("Error processing SAML response", (Throwable)e);
        }
    }

    private boolean isValidAssertion(Date notBefore, Date notOnOrAfter) {
        if (notBefore == null || notOnOrAfter == null) {
            this.logger.debug("Assertion is not valid because it does not have bounding dates.");
            return false;
        }
        ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
        ZonedDateTime startTime = ZonedDateTime.ofInstant(notBefore.toInstant().minusMillis(this.tolerance), ZoneOffset.UTC);
        ZonedDateTime endTime = ZonedDateTime.ofInstant(notOnOrAfter.toInstant().plusMillis(this.tolerance), ZoneOffset.UTC);
        if (!currentTime.isBefore(startTime) && endTime.isAfter(currentTime)) {
            this.logger.debug("Current time is within the interval validity.");
            return true;
        }
        if (currentTime.isBefore(startTime)) {
            this.logger.debug("Assertion is not yet valid");
        } else {
            this.logger.debug("Assertion is expired");
        }
        return false;
    }

    protected String retrieveResponseFromServer(URL validationUrl, String ticket) {
        String request = String.format(SAML_REQUEST_TEMPLATE, this.generateId(), SamlUtils.formatForUtcTime(new Date()), ticket);
        HttpURLConnection conn = null;
        try {
            conn = this.getURLConnectionFactory().buildHttpURLConnection(validationUrl.openConnection());
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setRequestProperty("SOAPAction", "http://www.oasis-open.org/committees/security");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            Charset charset = CommonUtils.isNotBlank((String)this.getEncoding()) ? Charset.forName(this.getEncoding()) : IOUtils.UTF8;
            conn.getOutputStream().write(request.getBytes(charset));
            String string = IOUtils.readString((InputStream)conn.getInputStream(), (Charset)charset);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("IO error sending HTTP request to /samlValidate", e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }

    private String generateId() {
        byte[] data = new byte[16];
        this.random.nextBytes(data);
        StringBuilder id = new StringBuilder(33);
        id.append('_');
        for (byte datum : data) {
            id.append(HEX_CHARS.charAt((datum & 0xF0) >> 4));
            id.append(HEX_CHARS.charAt(datum & 0xF));
        }
        return id.toString();
    }

    static {
        NS_CONTEXT = new MapNamespaceContext(new String[]{"soap->http://schemas.xmlsoap.org/soap/envelope/", "sa->urn:oasis:names:tc:SAML:1.0:assertion", "sp->urn:oasis:names:tc:SAML:1.0:protocol"});
        XPATH_ASSERTION_DATE_START = new ThreadLocalXPathExpression("//sa:Assertion/sa:Conditions/@NotBefore", NS_CONTEXT);
        XPATH_ASSERTION_DATE_END = new ThreadLocalXPathExpression("//sa:Assertion/sa:Conditions/@NotOnOrAfter", NS_CONTEXT);
        XPATH_NAME_ID = new ThreadLocalXPathExpression("//sa:AuthenticationStatement/sa:Subject/sa:NameIdentifier", NS_CONTEXT);
        XPATH_AUTH_METHOD = new ThreadLocalXPathExpression("//sa:AuthenticationStatement/@AuthenticationMethod", NS_CONTEXT);
        XPATH_ATTRIBUTES = new ThreadLocalXPathExpression("//sa:AttributeStatement/sa:Attribute", NS_CONTEXT);
        try {
            SAML_REQUEST_TEMPLATE = IOUtils.readString((InputStream)Saml11TicketValidator.class.getResourceAsStream("/META-INF/cas/samlRequestTemplate.xml"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load SAML request template from classpath", e);
        }
    }
}

