/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Locale;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.springframework.context.MessageSource;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowResourceELResolver
extends ELResolver {
    static final String RESOURCE_BUNDLE_KEY = "resourceBundle";
    private RequestContext requestContext;

    public FlowResourceELResolver() {
    }

    public FlowResourceELResolver(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return MessageSource.class;
        }
        if (base instanceof MessageSource) {
            return String.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        MessageSource messageSource;
        String message;
        RequestContext requestContext = this.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        if (base == null && RESOURCE_BUNDLE_KEY.equals(property)) {
            context.setPropertyResolved(true);
            return MessageSource.class;
        }
        if (base instanceof MessageSource && StringUtils.hasText((String)(message = (messageSource = (MessageSource)base).getMessage(property.toString(), null, null, this.getLocale())))) {
            context.setPropertyResolved(true);
            return String.class;
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        MessageSource messageSource;
        String message;
        RequestContext requestContext = this.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        if (base == null && RESOURCE_BUNDLE_KEY.equals(property)) {
            context.setPropertyResolved(true);
            return this.getMessageSource();
        }
        if (base instanceof MessageSource && StringUtils.hasText((String)(message = (messageSource = (MessageSource)base).getMessage(property.toString(), null, null, this.getLocale())))) {
            context.setPropertyResolved(true);
            return message;
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (requestContext == null) {
            return false;
        }
        if (base == null && RESOURCE_BUNDLE_KEY.equals(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        if (base instanceof MessageSource) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        RequestContext requestContext = this.getRequestContext();
        if (requestContext == null) {
            return;
        }
        if (base == null && RESOURCE_BUNDLE_KEY.equals(property)) {
            throw new PropertyNotWritableException("The 'resourceBundle' implicit variable is not writable.");
        }
        if (base instanceof MessageSource) {
            throw new PropertyNotWritableException("The flow's MessageSource is not writable.");
        }
    }

    protected Locale getLocale() {
        return this.getRequestContext().getExternalContext().getLocale();
    }

    protected MessageSource getMessageSource() {
        return this.getRequestContext().getActiveFlow().getApplicationContext();
    }

    protected RequestContext getRequestContext() {
        return this.requestContext != null ? this.requestContext : RequestContextHolder.getRequestContext();
    }
}

