/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.actuate;

import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class SyncopeCoreHealthIndicator
implements HealthIndicator {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeCoreHealthIndicator.class);
    protected final ServiceOps serviceOps;
    protected final String anonymousUser;
    protected final String anonymousKey;
    protected final boolean useGZIPCompression;

    public SyncopeCoreHealthIndicator(ServiceOps serviceOps, String anonymousUser, String anonymousKey, boolean useGZIPCompression) {
        this.serviceOps = serviceOps;
        this.anonymousUser = anonymousUser;
        this.anonymousKey = anonymousKey;
        this.useGZIPCompression = useGZIPCompression;
    }

    public Health health() {
        Health.Builder builder = new Health.Builder();
        try {
            ((UserSelfService)new SyncopeClientFactoryBean().setAddress(this.serviceOps.get(NetworkService.Type.CORE).getAddress()).setUseCompression(this.useGZIPCompression).create((AuthenticationHandler)new AnonymousAuthenticationHandler(this.anonymousUser, this.anonymousKey)).getService(UserSelfService.class)).read();
            builder.status(Status.UP);
        }
        catch (Exception e) {
            LOG.debug("When attempting to connect to Syncope Core", (Throwable)e);
            builder.status(Status.DOWN);
        }
        return builder.build();
    }
}

