/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.search;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.fiql.FiqlParser;
import org.apache.syncope.common.lib.search.SyncopeFiqlSearchCondition;

public class SyncopeFiqlParser<T>
extends FiqlParser<T> {
    public static final String IEQ = "=~";
    public static final String NIEQ = "!~";

    public SyncopeFiqlParser(Class<T> tclass, Map<String, String> contextProperties) {
        this(tclass, contextProperties, null);
    }

    public SyncopeFiqlParser(Class<T> tclass, Map<String, String> contextProperties, Map<String, String> beanProperties) {
        super(tclass, contextProperties, beanProperties);
        this.operatorsMap.put(IEQ, ConditionType.CUSTOM);
        this.operatorsMap.put(NIEQ, ConditionType.CUSTOM);
        CONDITION_MAP.put(ConditionType.CUSTOM, IEQ);
        CONDITION_MAP.put(ConditionType.CUSTOM, NIEQ);
        String comparators = "=gt=|=ge=|=lt=|=le=|==|!=|=~|!~";
        String s1 = "[\\p{ASCII}]+(" + comparators + ")";
        this.comparatorsPattern = Pattern.compile(s1);
    }

    protected FiqlParser.ASTNode<T> parseComparison(String expr) throws SearchParseException {
        Matcher m = this.comparatorsPattern.matcher(expr);
        if (m.find()) {
            String propertyName = expr.substring(0, m.start(1));
            String operator = m.group(1);
            String value = expr.substring(m.end(1));
            if (StringUtils.isBlank((CharSequence)value)) {
                throw new SearchParseException("Not a comparison expression: " + expr);
            }
            String name = this.getActualSetterName(this.unwrapSetter(propertyName));
            return Optional.ofNullable(this.parseType(propertyName, name, value)).map(typeInfoObject -> new SyncopeComparison(name, operator, (FiqlParser.TypeInfoObject)typeInfoObject)).orElse(null);
        }
        throw new SearchParseException("Not a comparison expression: " + expr);
    }

    private class SyncopeComparison
    implements FiqlParser.ASTNode<T> {
        private final String name;
        private final String operator;
        private final FiqlParser.TypeInfoObject tvalue;

        SyncopeComparison(String name, String operator, FiqlParser.TypeInfoObject value) {
            this.name = name;
            this.operator = operator;
            this.tvalue = value;
        }

        public String toString() {
            return this.name + " " + this.operator + " " + this.tvalue.getObject() + " (" + this.tvalue.getObject().getClass().getSimpleName() + ")";
        }

        public SearchCondition<T> build() throws SearchParseException {
            String templateName = SyncopeFiqlParser.this.getSetter(this.name);
            Object cond = this.createTemplate(templateName);
            ConditionType ct = (ConditionType)SyncopeFiqlParser.this.operatorsMap.get(this.operator);
            if (this.isPrimitive(cond)) {
                return new SyncopeFiqlSearchCondition(ct, cond);
            }
            String templateNameLCase = templateName.toLowerCase();
            return new SyncopeFiqlSearchCondition(Map.of(templateNameLCase, ct), Map.of(templateNameLCase, this.name), Map.of(templateNameLCase, this.tvalue.getTypeInfo()), cond, this.operator);
        }

        private boolean isPrimitive(T pojo) {
            return pojo.getClass().getName().startsWith("java.lang");
        }

        private T createTemplate(String setter) throws SearchParseException {
            try {
                if (SyncopeFiqlParser.this.beanspector != null) {
                    SyncopeFiqlParser.this.beanspector.instantiate().setValue(setter, this.tvalue.getObject());
                    return SyncopeFiqlParser.this.beanspector.getBean();
                }
                SearchBean bean = (SearchBean)SyncopeFiqlParser.this.conditionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                bean.set(setter, this.tvalue.getObject().toString());
                return bean;
            }
            catch (Throwable e) {
                throw new SearchParseException(e);
            }
        }
    }
}

